/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.cte;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.DeleteHandler;
import org.hibernate.query.sqm.mutation.internal.MatchingIdSelectionHelper;
import org.hibernate.query.sqm.mutation.internal.cte.AbstractCteMutationHandler;
import org.hibernate.query.sqm.mutation.internal.cte.CteStrategy;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.cte.CteTable;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class CteDeleteHandler
extends AbstractCteMutationHandler
implements DeleteHandler {
    private final SqlAstTranslatorFactory sqlAstTranslatorFactory;

    protected CteDeleteHandler(CteTable cteTable, SqmDeleteStatement sqmDeleteStatement, DomainParameterXref domainParameterXref, CteStrategy strategy, SessionFactoryImplementor sessionFactory) {
        super(cteTable, sqmDeleteStatement, domainParameterXref, strategy, sessionFactory);
        JdbcServices jdbcServices = this.getSessionFactory().getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        this.sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
    }

    @Override
    public SqmDeleteStatement getSqmDeleteOrUpdateStatement() {
        return (SqmDeleteStatement)super.getSqmDeleteOrUpdateStatement();
    }

    @Override
    public int execute(ExecutionContext executionContext) {
        List<Object> ids = MatchingIdSelectionHelper.selectMatchingIds(this.getSqmDeleteOrUpdateStatement(), this.getDomainParameterXref(), executionContext);
        if (ids == null || ids.isEmpty()) {
            return 0;
        }
        QuerySpec cteQuerySpec = this.getCteTable().createCteSubQuery(executionContext);
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(this.getDomainParameterXref().getQueryParameterCount());
        QuerySpec cteDefinitionQuerySpec = this.getCteTable().createCteDefinition(ids, this.getEntityDescriptor().getIdentifierMapping(), jdbcParameterBindings, executionContext);
        this.getEntityDescriptor().visitAttributeMappings(attribute -> {
            PluralAttributeMapping pluralAttribute;
            if (attribute instanceof PluralAttributeMapping && (pluralAttribute = (PluralAttributeMapping)attribute).getSeparateCollectionTable() != null) {
                this.executeDelete(cteDefinitionQuerySpec, pluralAttribute.getSeparateCollectionTable(), () -> columnConsumer -> pluralAttribute.getKeyDescriptor().visitReferringColumns((ColumnConsumer)columnConsumer), pluralAttribute.getKeyDescriptor(), cteQuerySpec, jdbcParameterBindings, executionContext);
            }
        });
        this.getEntityDescriptor().visitConstraintOrderedTables((tableExpression, tableColumnsVisitationSupplier) -> this.executeDelete(cteDefinitionQuerySpec, tableExpression, tableColumnsVisitationSupplier, this.getEntityDescriptor().getIdentifierMapping(), cteQuerySpec, jdbcParameterBindings, executionContext));
        return ids.size();
    }

    protected void executeDelete(QuerySpec cteDefinition, String targetTable, Supplier<Consumer<ColumnConsumer>> columnsToMatchVisitationSupplier, MappingModelExpressable cteType, QuerySpec cteSubQuery, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        CteStatement cteStatement = this.generateCteStatement(cteDefinition, targetTable, columnsToMatchVisitationSupplier, cteType, cteSubQuery, executionContext);
        SessionFactoryImplementor sessionFactory = this.getSessionFactory();
        JdbcDelete jdbcDelete = this.sqlAstTranslatorFactory.buildDeleteTranslator(sessionFactory).translate(cteStatement);
        LogicalConnectionImplementor logicalConnection = executionContext.getSession().getJdbcCoordinator().getLogicalConnection();
        sessionFactory.getJdbcServices().getJdbcMutationExecutor().execute(jdbcDelete, jdbcParameterBindings, sql -> {
            try {
                return logicalConnection.getPhysicalConnection().prepareStatement((String)sql);
            }
            catch (SQLException e) {
                throw sessionFactory.getJdbcServices().getSqlExceptionHelper().convert(e, "Error performing DELETE", (String)sql);
            }
        }, (integer, preparedStatement) -> {}, executionContext);
    }

    protected CteStatement generateCteStatement(QuerySpec cteDefinition, String targetTable, Supplier<Consumer<ColumnConsumer>> columnsToMatchVisitationSupplier, MappingModelExpressable cteType, QuerySpec cteSubQuery, ExecutionContext executionContext) {
        DeleteStatement deleteStatement = this.generateCteConsumer(targetTable, columnsToMatchVisitationSupplier, cteType, cteSubQuery, executionContext);
        return new CteStatement(cteDefinition, "id_cte", this.getCteTable(), deleteStatement);
    }

    private DeleteStatement generateCteConsumer(String targetTable, Supplier<Consumer<ColumnConsumer>> columnsToMatchVisitationSupplier, MappingModelExpressable cteType, QuerySpec cteSubQuery, ExecutionContext executionContext) {
        SessionFactoryImplementor sessionFactory = executionContext.getSession().getFactory();
        TableReference targetTableReference = new TableReference(targetTable, null, false, sessionFactory);
        ArrayList columnsToMatchReferences = new ArrayList();
        columnsToMatchVisitationSupplier.get().accept((columnExpression, containingTableExpression, jdbcMapping) -> columnsToMatchReferences.add(new ColumnReference(targetTableReference, columnExpression, jdbcMapping, sessionFactory)));
        Expression columnsToMatchExpression = columnsToMatchReferences.size() == 1 ? (Expression)columnsToMatchReferences.get(0) : new SqlTuple(columnsToMatchReferences, cteType);
        return new DeleteStatement(targetTableReference, new InSubQueryPredicate(columnsToMatchExpression, cteSubQuery, false));
    }
}

