/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.ExecuteWithIdTableHelper;
import org.hibernate.query.sqm.mutation.internal.idtable.ExecuteWithoutIdTableHelper;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableExporter;
import org.hibernate.query.sqm.mutation.internal.idtable.TableBasedDeleteHandler;
import org.hibernate.query.sqm.mutation.internal.idtable.TableKeyExpressionCollector;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.sql.ast.SqlAstDeleteTranslator;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.jboss.logging.Logger;

public class RestrictedDeleteExecutionDelegate
implements TableBasedDeleteHandler.ExecutionDelegate {
    private static final Logger log = Logger.getLogger(RestrictedDeleteExecutionDelegate.class);
    private final EntityMappingType entityDescriptor;
    private final IdTable idTable;
    private final SqmDeleteStatement sqmDelete;
    private final DomainParameterXref domainParameterXref;
    private final SessionFactoryImplementor sessionFactory;
    private final BeforeUseAction beforeUseAction;
    private final AfterUseAction afterUseAction;
    private final TempTableDdlTransactionHandling ddlTransactionHandling;
    private final Supplier<IdTableExporter> idTableExporterAccess;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final MultiTableSqmMutationConverter converter;

    public RestrictedDeleteExecutionDelegate(EntityMappingType entityDescriptor, IdTable idTable, SqmDeleteStatement sqmDelete, DomainParameterXref domainParameterXref, BeforeUseAction beforeUseAction, AfterUseAction afterUseAction, TempTableDdlTransactionHandling ddlTransactionHandling, Supplier<IdTableExporter> idTableExporterAccess, Function<SharedSessionContractImplementor, String> sessionUidAccess, QueryOptions queryOptions, QueryParameterBindings queryParameterBindings, SessionFactoryImplementor sessionFactory) {
        this.entityDescriptor = entityDescriptor;
        this.idTable = idTable;
        this.sqmDelete = sqmDelete;
        this.domainParameterXref = domainParameterXref;
        this.beforeUseAction = beforeUseAction;
        this.afterUseAction = afterUseAction;
        this.ddlTransactionHandling = ddlTransactionHandling;
        this.idTableExporterAccess = idTableExporterAccess;
        this.sessionUidAccess = sessionUidAccess;
        this.sessionFactory = sessionFactory;
        this.converter = new MultiTableSqmMutationConverter(entityDescriptor, domainParameterXref, queryOptions, queryParameterBindings, sessionFactory);
    }

    @Override
    public int execute(ExecutionContext executionContext) {
        EntityPersister entityDescriptor = this.sessionFactory.getDomainModel().getEntityDescriptor(((SqmRoot)this.sqmDelete.getTarget()).getEntityName());
        String hierarchyRootTableName = ((Joinable)((Object)entityDescriptor)).getTableName();
        TableGroup deletingTableGroup = this.converter.getMutatingTableGroup();
        TableReference hierarchyRootTableReference = deletingTableGroup.resolveTableReference(hierarchyRootTableName);
        assert (hierarchyRootTableReference != null);
        Map<SqmParameter, List<JdbcParameter>> parameterResolutions = this.domainParameterXref.getSqmParameterCount() == 0 ? Collections.emptyMap() : new IdentityHashMap();
        AtomicBoolean needsIdTableWrapper = new AtomicBoolean(false);
        Predicate predicate = this.converter.visitWhereClause(this.sqmDelete.getWhereClause(), columnReference -> {
            if (!hierarchyRootTableReference.getIdentificationVariable().equals(columnReference.getQualifier())) {
                needsIdTableWrapper.set(true);
            }
        }, parameterResolutions::put);
        boolean needsIdTable = needsIdTableWrapper.get();
        if (needsIdTable) {
            return this.executeWithIdTable(predicate, deletingTableGroup, parameterResolutions, executionContext);
        }
        return this.executeWithoutIdTable(predicate, deletingTableGroup, parameterResolutions, this.converter.getSqlExpressionResolver(), executionContext);
    }

    private int executeWithoutIdTable(Predicate suppliedPredicate, TableGroup tableGroup, Map<SqmParameter, List<JdbcParameter>> restrictionSqmParameterResolutions, SqlExpressionResolver sqlExpressionResolver, ExecutionContext executionContext) {
        String rootEntityName = this.entityDescriptor.getEntityPersister().getRootEntityName();
        EntityPersister rootEntityPersister = rootEntityName.equals(this.entityDescriptor.getEntityName()) ? this.entityDescriptor.getEntityPersister() : this.sessionFactory.getDomainModel().findEntityDescriptor(rootEntityName);
        AtomicInteger rows = new AtomicInteger();
        String rootTableName = ((Joinable)((Object)rootEntityPersister)).getTableName();
        TableReference rootTableReference = tableGroup.resolveTableReference(rootTableName);
        QuerySpec matchingIdSubQuerySpec = ExecuteWithoutIdTableHelper.createIdMatchingSubQuerySpec(tableGroup.getNavigablePath(), rootTableReference, suppliedPredicate, rootEntityPersister, sqlExpressionResolver, this.sessionFactory);
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, SqmUtil.generateJdbcParamsXref(this.domainParameterXref, () -> restrictionSqmParameterResolutions), this.sessionFactory.getDomainModel(), navigablePath -> tableGroup, executionContext.getSession());
        this.entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> {
            if (tableExpression.equals(rootTableName)) {
                rows.set(this.deleteFromRootTableWithoutIdTable(rootTableReference, suppliedPredicate, jdbcParameterBindings, executionContext));
            } else {
                this.deleteFromNonRootTableWithoutIdTable(tableGroup.resolveTableReference(tableExpression), tableKeyColumnVisitationSupplier, sqlExpressionResolver, tableGroup, matchingIdSubQuerySpec, jdbcParameterBindings, executionContext);
            }
        });
        return rows.get();
    }

    private int deleteFromRootTableWithoutIdTable(TableReference rootTableReference, Predicate predicate, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        return RestrictedDeleteExecutionDelegate.executeSqlDelete(new DeleteStatement(rootTableReference, predicate), jdbcParameterBindings, executionContext);
    }

    private void deleteFromNonRootTableWithoutIdTable(TableReference targetTableReference, Supplier<Consumer<ColumnConsumer>> tableKeyColumnVisitationSupplier, SqlExpressionResolver sqlExpressionResolver, TableGroup rootTableGroup, QuerySpec matchingIdSubQuerySpec, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        assert (targetTableReference != null);
        log.trace((Object)("deleteFromNonRootTable - " + targetTableReference.getTableExpression()));
        ArrayList deletingTableColumnRefs = new ArrayList();
        tableKeyColumnVisitationSupplier.get().accept((columnExpression, containingTableExpression, jdbcMapping) -> {
            assert (targetTableReference.getTableExpression().equals(containingTableExpression));
            Expression expression = sqlExpressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(targetTableReference, columnExpression), sqlAstProcessingState -> new ColumnReference(rootTableGroup.getPrimaryTableReference(), columnExpression, jdbcMapping, this.sessionFactory));
            deletingTableColumnRefs.add((ColumnReference)expression);
        });
        Expression deletingTableColumnRefsExpression = deletingTableColumnRefs.size() == 1 ? (Expression)deletingTableColumnRefs.get(0) : new SqlTuple(deletingTableColumnRefs, this.entityDescriptor.getIdentifierMapping());
        InSubQueryPredicate idMatchPredicate = new InSubQueryPredicate(deletingTableColumnRefsExpression, matchingIdSubQuerySpec, false);
        DeleteStatement sqlAstDelete = new DeleteStatement(targetTableReference, idMatchPredicate);
        int rows = RestrictedDeleteExecutionDelegate.executeSqlDelete(sqlAstDelete, jdbcParameterBindings, executionContext);
        log.debugf("deleteFromNonRootTable - `%s` : %s rows", (Object)targetTableReference, (Object)rows);
    }

    private static int executeSqlDelete(DeleteStatement sqlAst, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        JdbcServices jdbcServices = factory.getJdbcServices();
        SqlAstDeleteTranslator sqlAstTranslator = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildDeleteTranslator(factory);
        JdbcDelete jdbcDelete = sqlAstTranslator.translate(sqlAst);
        return jdbcServices.getJdbcMutationExecutor().execute(jdbcDelete, jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeWithIdTable(Predicate predicate, TableGroup deletingTableGroup, Map<SqmParameter, List<JdbcParameter>> restrictionSqmParameterResolutions, ExecutionContext executionContext) {
        JdbcParameterBindings jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), this.domainParameterXref, SqmUtil.generateJdbcParamsXref(this.domainParameterXref, () -> restrictionSqmParameterResolutions), this.sessionFactory.getDomainModel(), navigablePath -> deletingTableGroup, executionContext.getSession());
        ExecuteWithIdTableHelper.performBeforeIdTableUseActions(this.beforeUseAction, this.idTable, this.idTableExporterAccess, this.ddlTransactionHandling, executionContext);
        try {
            int n = this.executeUsingIdTable(predicate, executionContext, jdbcParameterBindings);
            return n;
        }
        finally {
            ExecuteWithIdTableHelper.performAfterIdTableUseActions(this.afterUseAction, this.idTable, this.idTableExporterAccess, this.ddlTransactionHandling, this.sessionUidAccess, executionContext);
        }
    }

    private int executeUsingIdTable(Predicate predicate, ExecutionContext executionContext, JdbcParameterBindings jdbcParameterBindings) {
        int rows = ExecuteWithIdTableHelper.saveMatchingIdsIntoIdTable(this.converter, predicate, this.idTable, this.sessionUidAccess, jdbcParameterBindings, executionContext);
        QuerySpec idTableSubQuery = ExecuteWithIdTableHelper.createIdTableSelectQuerySpec(this.idTable, this.sessionUidAccess, this.entityDescriptor, executionContext);
        this.entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> this.deleteFromTableUsingIdTable(tableExpression, tableKeyColumnVisitationSupplier, idTableSubQuery, executionContext));
        return rows;
    }

    private void deleteFromTableUsingIdTable(String tableExpression, Supplier<Consumer<ColumnConsumer>> tableKeyColumnVisitationSupplier, QuerySpec idTableSubQuery, ExecutionContext executionContext) {
        log.trace((Object)("deleteFromTableUsingIdTable - " + tableExpression));
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        TableKeyExpressionCollector keyColumnCollector = new TableKeyExpressionCollector(this.entityDescriptor);
        tableKeyColumnVisitationSupplier.get().accept((columnExpression, containingTableExpression, jdbcMapping) -> {
            assert (containingTableExpression.equals(tableExpression));
            keyColumnCollector.apply(new ColumnReference((String)null, columnExpression, jdbcMapping, factory));
        });
        InSubQueryPredicate predicate = new InSubQueryPredicate(keyColumnCollector.buildKeyExpression(), idTableSubQuery, false);
        RestrictedDeleteExecutionDelegate.executeSqlDelete(new DeleteStatement(new TableReference(tableExpression, null, true, factory), predicate), JdbcParameterBindings.NO_BINDINGS, executionContext);
    }
}

