/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.mutation.internal.DeleteHandler;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableExporter;
import org.hibernate.query.sqm.mutation.internal.idtable.RestrictedDeleteExecutionDelegate;
import org.hibernate.query.sqm.mutation.internal.idtable.UnrestrictedDeleteExecutionDelegate;
import org.hibernate.query.sqm.mutation.spi.AbstractMutationHandler;
import org.hibernate.query.sqm.tree.delete.SqmDeleteStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.jboss.logging.Logger;

public class TableBasedDeleteHandler
extends AbstractMutationHandler
implements DeleteHandler {
    private static final Logger log = Logger.getLogger(TableBasedDeleteHandler.class);
    private final IdTable idTable;
    private final TempTableDdlTransactionHandling ddlTransactionHandling;
    private final BeforeUseAction beforeUseAction;
    private final AfterUseAction afterUseAction;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final Supplier<IdTableExporter> exporterSupplier;
    private final DomainParameterXref domainParameterXref;

    public TableBasedDeleteHandler(SqmDeleteStatement sqmDeleteStatement, DomainParameterXref domainParameterXref, IdTable idTable, Function<SharedSessionContractImplementor, String> sessionUidAccess, Supplier<IdTableExporter> exporterSupplier, BeforeUseAction beforeUseAction, AfterUseAction afterUseAction, TempTableDdlTransactionHandling ddlTransactionHandling, SessionFactoryImplementor sessionFactory) {
        super(sqmDeleteStatement, sessionFactory);
        this.idTable = idTable;
        this.ddlTransactionHandling = ddlTransactionHandling;
        this.beforeUseAction = beforeUseAction;
        this.afterUseAction = afterUseAction;
        this.domainParameterXref = domainParameterXref;
        this.sessionUidAccess = sessionUidAccess;
        this.exporterSupplier = exporterSupplier;
    }

    @Override
    public int execute(ExecutionContext executionContext) {
        log.tracef("Starting multi-table delete execution - %s", (Object)this.getSqmDeleteOrUpdateStatement().getRoot().getModel().getName());
        return this.resolveDelegate(executionContext).execute(executionContext);
    }

    private ExecutionDelegate resolveDelegate(ExecutionContext executionContext) {
        if (this.getSqmDeleteOrUpdateStatement().getWhereClause() == null || this.getSqmDeleteOrUpdateStatement().getWhereClause().getPredicate() == null) {
            return new UnrestrictedDeleteExecutionDelegate(this.getEntityDescriptor());
        }
        return new RestrictedDeleteExecutionDelegate(this.getEntityDescriptor(), this.idTable, this.getSqmDeleteOrUpdateStatement(), this.domainParameterXref, this.beforeUseAction, this.afterUseAction, this.ddlTransactionHandling, this.exporterSupplier, this.sessionUidAccess, executionContext.getQueryOptions(), executionContext.getQueryParameterBindings(), this.getSessionFactory());
    }

    @Override
    public SqmDeleteStatement getSqmDeleteOrUpdateStatement() {
        return (SqmDeleteStatement)super.getSqmDeleteOrUpdateStatement();
    }

    public static interface ExecutionDelegate {
        public int execute(ExecutionContext var1);
    }
}

