/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.query.sqm.mutation.internal.idtable.TableBasedDeleteHandler;
import org.hibernate.sql.ast.SqlAstDeleteTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcDelete;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class UnrestrictedDeleteExecutionDelegate
implements TableBasedDeleteHandler.ExecutionDelegate {
    private final EntityMappingType entityDescriptor;

    public UnrestrictedDeleteExecutionDelegate(EntityMappingType entityDescriptor) {
        this.entityDescriptor = entityDescriptor;
    }

    @Override
    public int execute(ExecutionContext executionContext) {
        AtomicInteger result = new AtomicInteger();
        this.entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnsVisitationSupplier) -> {
            int rows = this.deleteFrom(tableExpression, executionContext);
            result.set(rows);
        });
        return result.get();
    }

    private int deleteFrom(String tableExpression, ExecutionContext executionContext) {
        SessionFactoryImplementor factory = executionContext.getSession().getFactory();
        DeleteStatement deleteStatement = new DeleteStatement(new TableReference(tableExpression, null, true, factory), null);
        JdbcServices jdbcServices = factory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        SqlAstTranslatorFactory sqlAstTranslatorFactory = jdbcEnvironment.getSqlAstTranslatorFactory();
        SqlAstDeleteTranslator sqlAstTranslator = sqlAstTranslatorFactory.buildDeleteTranslator(factory);
        JdbcDelete jdbcDelete = sqlAstTranslator.translate(deleteStatement);
        return jdbcServices.getJdbcMutationExecutor().execute(jdbcDelete, JdbcParameterBindings.NO_BINDINGS, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }
}

