/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.idtable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.mutation.internal.MultiTableSqmMutationConverter;
import org.hibernate.query.sqm.mutation.internal.idtable.AfterUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.BeforeUseAction;
import org.hibernate.query.sqm.mutation.internal.idtable.ExecuteWithIdTableHelper;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTable;
import org.hibernate.query.sqm.mutation.internal.idtable.IdTableExporter;
import org.hibernate.query.sqm.mutation.internal.idtable.TableBasedUpdateHandler;
import org.hibernate.query.sqm.mutation.internal.idtable.TableKeyExpressionCollector;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.SqlAstUpdateTranslator;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcUpdate;

public class UpdateExecutionDelegate
implements TableBasedUpdateHandler.ExecutionDelegate {
    private final SqmUpdateStatement sqmUpdate;
    private final MultiTableSqmMutationConverter sqmConverter;
    private final IdTable idTable;
    private final TempTableDdlTransactionHandling ddlTransactionHandling;
    private final BeforeUseAction beforeUseAction;
    private final AfterUseAction afterUseAction;
    private final Function<SharedSessionContractImplementor, String> sessionUidAccess;
    private final Supplier<IdTableExporter> idTableExporterAccess;
    private final DomainParameterXref domainParameterXref;
    private final TableGroup updatingTableGroup;
    private final Predicate suppliedPredicate;
    private final EntityMappingType entityDescriptor;
    private final JdbcParameterBindings jdbcParameterBindings;
    private final Map<TableReference, List<Assignment>> assignmentsByTable;
    private final SessionFactoryImplementor sessionFactory;

    public UpdateExecutionDelegate(SqmUpdateStatement sqmUpdate, MultiTableSqmMutationConverter sqmConverter, IdTable idTable, TempTableDdlTransactionHandling ddlTransactionHandling, BeforeUseAction beforeUseAction, AfterUseAction afterUseAction, Function<SharedSessionContractImplementor, String> sessionUidAccess, Supplier<IdTableExporter> idTableExporterAccess, DomainParameterXref domainParameterXref, TableGroup updatingTableGroup, TableReference hierarchyRootTableReference, Map<String, TableReference> tableReferenceByAlias, List<Assignment> assignments, Predicate suppliedPredicate, Map<SqmParameter, List<JdbcParameter>> parameterResolutions, ExecutionContext executionContext) {
        this.sqmUpdate = sqmUpdate;
        this.sqmConverter = sqmConverter;
        this.idTable = idTable;
        this.ddlTransactionHandling = ddlTransactionHandling;
        this.beforeUseAction = beforeUseAction;
        this.afterUseAction = afterUseAction;
        this.sessionUidAccess = sessionUidAccess;
        this.idTableExporterAccess = idTableExporterAccess;
        this.domainParameterXref = domainParameterXref;
        this.updatingTableGroup = updatingTableGroup;
        this.suppliedPredicate = suppliedPredicate;
        this.sessionFactory = executionContext.getSession().getFactory();
        ModelPartContainer updatingModelPart = updatingTableGroup.getModelPart();
        assert (updatingModelPart instanceof EntityMappingType);
        this.entityDescriptor = (EntityMappingType)updatingModelPart;
        this.assignmentsByTable = new HashMap<TableReference, List<Assignment>>(updatingTableGroup.getTableReferenceJoins().size() + 1);
        this.jdbcParameterBindings = SqmUtil.createJdbcParameterBindings(executionContext.getQueryParameterBindings(), domainParameterXref, SqmUtil.generateJdbcParamsXref(domainParameterXref, () -> parameterResolutions), this.sessionFactory.getDomainModel(), navigablePath -> updatingTableGroup, executionContext.getSession());
        for (int i = 0; i < assignments.size(); ++i) {
            Assignment assignment = assignments.get(i);
            List<ColumnReference> assignmentColumnRefs = assignment.getAssignable().getColumnReferences();
            TableReference assignmentTableReference = null;
            for (int c = 0; c < assignmentColumnRefs.size(); ++c) {
                ColumnReference columnReference = assignmentColumnRefs.get(c);
                TableReference tableReference = this.resolveTableReference(columnReference, updatingTableGroup, tableReferenceByAlias);
                if (assignmentTableReference != null && assignmentTableReference != tableReference) {
                    throw new IllegalStateException("Assignment referred to columns from multiple tables");
                }
                assignmentTableReference = tableReference;
            }
            List<Assignment> assignmentsForTable = this.assignmentsByTable.get(assignmentTableReference);
            if (assignmentsForTable == null) {
                assignmentsForTable = new ArrayList<Assignment>();
                this.assignmentsByTable.put(assignmentTableReference, assignmentsForTable);
            }
            assignmentsForTable.add(assignment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(ExecutionContext executionContext) {
        ExecuteWithIdTableHelper.performBeforeIdTableUseActions(this.beforeUseAction, this.idTable, this.idTableExporterAccess, this.ddlTransactionHandling, executionContext);
        try {
            int rows = ExecuteWithIdTableHelper.saveMatchingIdsIntoIdTable(this.sqmConverter, this.suppliedPredicate, this.idTable, this.sessionUidAccess, this.jdbcParameterBindings, executionContext);
            QuerySpec idTableSubQuery = ExecuteWithIdTableHelper.createIdTableSelectQuerySpec(this.idTable, this.sessionUidAccess, this.entityDescriptor, executionContext);
            this.entityDescriptor.visitConstraintOrderedTables((tableExpression, tableKeyColumnVisitationSupplier) -> this.updateTable(tableExpression, tableKeyColumnVisitationSupplier, idTableSubQuery, executionContext));
            int n = rows;
            return n;
        }
        finally {
            ExecuteWithIdTableHelper.performAfterIdTableUseActions(this.afterUseAction, this.idTable, this.idTableExporterAccess, this.ddlTransactionHandling, this.sessionUidAccess, executionContext);
        }
    }

    private TableReference resolveTableReference(ColumnReference columnReference, TableGroup updatingTableGroup, Map<String, TableReference> tableReferenceByAlias) {
        TableReference tableReferenceByQualifier = tableReferenceByAlias.get(columnReference.getQualifier());
        if (tableReferenceByQualifier != null) {
            return tableReferenceByQualifier;
        }
        TableReference tableReferenceByName = updatingTableGroup.resolveTableReference(columnReference.getQualifier());
        if (tableReferenceByName != null) {
            return tableReferenceByName;
        }
        throw new IllegalStateException("Could not resolve restricted column's table-reference");
    }

    private void updateTable(String tableExpression, Supplier<Consumer<ColumnConsumer>> tableKeyColumnVisitationSupplier, QuerySpec idTableSubQuery, ExecutionContext executionContext) {
        TableReference updatingTableReference = this.updatingTableGroup.resolveTableReference(tableExpression);
        List<Assignment> assignments = this.assignmentsByTable.get(updatingTableReference);
        if (assignments == null || assignments.isEmpty()) {
            return;
        }
        TableKeyExpressionCollector keyColumnCollector = new TableKeyExpressionCollector(this.entityDescriptor);
        tableKeyColumnVisitationSupplier.get().accept((columnExpression, containingTableExpression, jdbcMapping) -> {
            assert (containingTableExpression.equals(tableExpression));
            keyColumnCollector.apply(new ColumnReference((String)null, columnExpression, jdbcMapping, this.sessionFactory));
        });
        InSubQueryPredicate idTableSubQueryPredicate = new InSubQueryPredicate(keyColumnCollector.buildKeyExpression(), idTableSubQuery, false);
        UpdateStatement sqlAst = new UpdateStatement(updatingTableReference, assignments, idTableSubQueryPredicate);
        JdbcServices jdbcServices = this.sessionFactory.getJdbcServices();
        SqlAstUpdateTranslator sqlAstTranslator = jdbcServices.getJdbcEnvironment().getSqlAstTranslatorFactory().buildUpdateTranslator(this.sessionFactory);
        JdbcUpdate jdbcUpdate = sqlAstTranslator.translate(sqlAst);
        jdbcServices.getJdbcMutationExecutor().execute(jdbcUpdate, this.jdbcParameterBindings, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), (integer, preparedStatement) -> {}, executionContext);
    }
}

