/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.mutation.internal.inline;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.ColumnConsumer;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.ComparisonOperator;
import org.hibernate.query.sqm.mutation.internal.inline.MatchingIdRestrictionProducer;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.exec.spi.ExecutionContext;

public class DisjunctionRestrictionProducer
implements MatchingIdRestrictionProducer {
    @Override
    public Junction produceRestriction(List<?> matchingIdValues, EntityMappingType entityDescriptor, TableReference mutatingTableReference, Supplier<Consumer<ColumnConsumer>> columnsToMatchVisitationSupplier, ExecutionContext executionContext) {
        assert (matchingIdValues != null);
        assert (!matchingIdValues.isEmpty());
        SessionFactoryImplementor sessionFactory = executionContext.getSession().getFactory();
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        int idColumnCount = identifierMapping.getJdbcTypeCount(sessionFactory.getTypeConfiguration());
        assert (idColumnCount > 0);
        Junction predicate = new Junction(Junction.Nature.DISJUNCTION);
        if (idColumnCount == 1) {
            BasicValuedModelPart basicIdMapping = (BasicValuedModelPart)((Object)identifierMapping);
            String idColumn = basicIdMapping.getMappedColumnExpression();
            ColumnReference idColumnReference = new ColumnReference(mutatingTableReference, idColumn, basicIdMapping.getJdbcMapping(), sessionFactory);
            for (int i = 0; i < matchingIdValues.size(); ++i) {
                Object matchingId = matchingIdValues.get(i);
                predicate.add(new ComparisonPredicate(idColumnReference, ComparisonOperator.EQUAL, new JdbcLiteral(matchingId, basicIdMapping.getJdbcMapping())));
            }
        } else {
            ArrayList columnReferences = new ArrayList(idColumnCount);
            ArrayList jdbcMappings = new ArrayList(idColumnCount);
            identifierMapping.visitColumns((columnExpression, containingTableExpression, jdbcMapping) -> {
                columnReferences.add(new ColumnReference(mutatingTableReference, columnExpression, jdbcMapping, sessionFactory));
                jdbcMappings.add(jdbcMapping);
            });
            for (int i = 0; i < matchingIdValues.size(); ++i) {
                Junction idMatch = new Junction(Junction.Nature.CONJUNCTION);
                Object matchingId = matchingIdValues.get(i);
                assert (matchingId instanceof Object[]);
                Object[] matchingIdParts = (Object[])matchingId;
                for (int p = 0; p < matchingIdParts.length; ++p) {
                    idMatch.add(new ComparisonPredicate((Expression)columnReferences.get(p), ComparisonOperator.EQUAL, new JdbcLiteral<Object>(matchingIdParts[p], (JdbcMapping)jdbcMappings.get(p))));
                }
                predicate.add(idMatch);
            }
        }
        return predicate;
    }
}

