/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function;

import java.util.List;
import java.util.Locale;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.QueryException;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.tree.SqmTypedNode;

public class StandardFunctionReturnTypeResolvers {
    private StandardFunctionReturnTypeResolvers() {
    }

    public static FunctionReturnTypeResolver invariant(AllowableFunctionReturnType invariantType) {
        if (invariantType == null) {
            throw new IllegalArgumentException("Passed `invariantType` for function return cannot be null");
        }
        return (impliedType, arguments) -> StandardFunctionReturnTypeResolvers.useImpliedTypeIfPossible(invariantType, impliedType);
    }

    public static FunctionReturnTypeResolver useArgType(int argPosition) {
        return (impliedType, arguments) -> {
            AllowableFunctionReturnType specifiedArgType = StandardFunctionReturnTypeResolvers.extractArgumentType(arguments, argPosition);
            return StandardFunctionReturnTypeResolvers.useImpliedTypeIfPossible(specifiedArgType, impliedType);
        };
    }

    public static FunctionReturnTypeResolver useFirstNonNull() {
        return (impliedType, arguments) -> {
            for (SqmTypedNode arg : arguments) {
                if (arg == null || !(arg.getNodeType() instanceof AllowableFunctionReturnType)) continue;
                AllowableFunctionReturnType argType = (AllowableFunctionReturnType)arg.getNodeType();
                return StandardFunctionReturnTypeResolvers.useImpliedTypeIfPossible(argType, impliedType);
            }
            return impliedType;
        };
    }

    private static AllowableFunctionReturnType<?> useImpliedTypeIfPossible(AllowableFunctionReturnType<?> defined, AllowableFunctionReturnType<?> implied) {
        return StandardFunctionReturnTypeResolvers.areCompatible(defined, implied) ? implied : defined;
    }

    private static boolean areCompatible(AllowableFunctionReturnType<?> defined, AllowableFunctionReturnType<?> implied) {
        throw new NotYetImplementedFor6Exception(StandardFunctionReturnTypeResolvers.class);
    }

    private static boolean isInteger(int type) {
        return type == 4 || type == -5 || type == 5 || type == -6;
    }

    private static boolean isFloat(int type) {
        return type == 6 || type == 8;
    }

    private static AllowableFunctionReturnType extractArgumentType(List<SqmTypedNode<?>> arguments, int position) {
        SqmTypedNode<?> specifiedArgument = arguments.get(position - 1);
        SqmExpressable<?> specifiedArgType = specifiedArgument.getNodeType();
        if (!(specifiedArgType instanceof AllowableFunctionReturnType)) {
            throw new QueryException(String.format(Locale.ROOT, "Function argument [%s] at specified position [%d] in call arguments was not typed as an allowable function return type", specifiedArgument, position));
        }
        return (AllowableFunctionReturnType)specifiedArgType;
    }
}

