/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function.spi;

import java.util.List;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.tree.SqmTypedNode;

public abstract class AbstractSqmFunctionTemplate
implements SqmFunctionTemplate {
    private final ArgumentsValidator argumentsValidator;
    private final FunctionReturnTypeResolver returnTypeResolver;

    public AbstractSqmFunctionTemplate() {
        this(null, null);
    }

    public AbstractSqmFunctionTemplate(ArgumentsValidator argumentsValidator) {
        this(argumentsValidator, null);
    }

    public AbstractSqmFunctionTemplate(ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver) {
        this.argumentsValidator = argumentsValidator == null ? StandardArgumentsValidators.NONE : argumentsValidator;
        this.returnTypeResolver = returnTypeResolver == null ? StandardFunctionReturnTypeResolvers.useFirstNonNull() : returnTypeResolver;
    }

    @Override
    public final <T> SelfRenderingSqmFunction<T> makeSqmFunctionExpression(List<SqmTypedNode<?>> arguments, AllowableFunctionReturnType<T> impliedResultType, QueryEngine queryEngine) {
        this.argumentsValidator.validate(arguments);
        return this.generateSqmFunctionExpression(arguments, this.returnTypeResolver.resolveFunctionReturnType(impliedResultType, arguments), queryEngine);
    }

    protected abstract <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<SqmTypedNode<?>> var1, AllowableFunctionReturnType<T> var2, QueryEngine var3);
}

