/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function.spi;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.spi.AbstractSelfRenderingFunctionTemplate;
import org.hibernate.query.sqm.produce.function.spi.SelfRenderingFunctionSupport;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.jboss.logging.Logger;

public class FunctionAsExpressionTemplate
extends AbstractSelfRenderingFunctionTemplate
implements SelfRenderingFunctionSupport {
    private static final Logger log = Logger.getLogger(FunctionAsExpressionTemplate.class);
    private final String expressionStart;
    private final String argumentSeparator;
    private final String expressionEnd;

    public FunctionAsExpressionTemplate(String expressionStart, String argumentSeparator, String expressionEnd, FunctionReturnTypeResolver returnTypeResolver, ArgumentsValidator argumentsValidator, String name) {
        super(name, returnTypeResolver, argumentsValidator);
        this.expressionStart = expressionStart;
        this.argumentSeparator = argumentSeparator;
        this.expressionEnd = expressionEnd;
    }

    @Override
    protected SelfRenderingFunctionSupport getRenderingFunctionSupport(List<SqmTypedNode<?>> arguments, AllowableFunctionReturnType<?> resolvedReturnType, QueryEngine queryEngine) {
        return this;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> sqlAstArguments, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
        sqlAppender.appendSql(this.expressionStart);
        if (sqlAstArguments.isEmpty()) {
            log.debugf("No arguments found for FunctionAsExpressionTemplate, this is most likely a query syntax error", new Object[0]);
        } else {
            this.renderArgument(sqlAppender, sqlAstArguments.get(0), walker, sessionFactory);
            for (int i = 1; i < sqlAstArguments.size(); ++i) {
                sqlAppender.appendSql(this.argumentSeparator);
                this.renderArgument(sqlAppender, sqlAstArguments.get(i), walker, sessionFactory);
            }
        }
        sqlAppender.appendSql(this.expressionEnd);
    }

    protected void renderArgument(SqlAppender sqlAppender, SqlAstNode sqlAstArgument, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
        sqlAstArgument.accept(walker);
    }
}

