/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function.spi;

import java.util.List;
import java.util.Locale;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.produce.function.ArgumentsValidator;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.spi.AbstractSelfRenderingFunctionTemplate;
import org.hibernate.query.sqm.produce.function.spi.SelfRenderingFunctionSupport;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;

public class NamedSqmFunctionTemplate
extends AbstractSelfRenderingFunctionTemplate
implements SelfRenderingFunctionSupport {
    private final String functionName;
    private final boolean useParenthesesWhenNoArgs;

    public NamedSqmFunctionTemplate(String functionName, boolean useParenthesesWhenNoArgs, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver) {
        this(functionName, useParenthesesWhenNoArgs, argumentsValidator, returnTypeResolver, functionName);
    }

    public NamedSqmFunctionTemplate(String functionName, boolean useParenthesesWhenNoArgs, ArgumentsValidator argumentsValidator, FunctionReturnTypeResolver returnTypeResolver, String name) {
        super(name, returnTypeResolver, argumentsValidator);
        this.functionName = functionName;
        this.useParenthesesWhenNoArgs = useParenthesesWhenNoArgs;
    }

    public String getName() {
        return this.functionName;
    }

    @Override
    protected SelfRenderingFunctionSupport getRenderingFunctionSupport(List<SqmTypedNode<?>> arguments, AllowableFunctionReturnType<?> impliedResultType, QueryEngine queryEngine) {
        return this;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> sqlAstArguments, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
        boolean useParens = this.useParenthesesWhenNoArgs || !sqlAstArguments.isEmpty();
        sqlAppender.appendSql(this.functionName);
        if (useParens) {
            sqlAppender.appendSql("(");
        }
        boolean firstPass = true;
        for (SqlAstNode sqlAstArgument : sqlAstArguments) {
            if (!firstPass) {
                sqlAppender.appendSql(", ");
            }
            this.renderArgument(sqlAppender, sqlAstArgument, walker, sessionFactory);
            firstPass = false;
        }
        if (useParens) {
            sqlAppender.appendSql(")");
        }
    }

    protected void renderArgument(SqlAppender sqlAppender, SqlAstNode sqlAstArgument, SqlAstWalker walker, SessionFactoryImplementor sessionFactory) {
        sqlAstArgument.accept(walker);
    }

    public String toString() {
        return String.format(Locale.ROOT, "NamedSqmFunctionTemplate(%s)", this.functionName);
    }
}

