/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.produce.function.spi;

import java.util.List;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sqm.produce.function.SqmFunctionTemplate;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.internal.SelfRenderingSqmFunction;
import org.hibernate.query.sqm.produce.function.spi.AbstractSqmFunctionTemplate;
import org.hibernate.query.sqm.tree.SqmTypedNode;

public class PairedFunctionTemplate
extends AbstractSqmFunctionTemplate {
    private SqmFunctionTemplate binaryFunction;
    private SqmFunctionTemplate ternaryFunction;

    public PairedFunctionTemplate(SqmFunctionTemplate binaryFunction, SqmFunctionTemplate ternaryFunction) {
        super(StandardArgumentsValidators.between(2, 3));
        this.binaryFunction = binaryFunction;
        this.ternaryFunction = ternaryFunction;
    }

    public static void register(QueryEngine queryEngine, String name, AllowableFunctionReturnType type, String pattern2, String pattern3) {
        queryEngine.getSqmFunctionRegistry().register(name, new PairedFunctionTemplate(queryEngine.getSqmFunctionRegistry().patternTemplateBuilder(name, pattern2).setExactArgumentCount(2).setInvariantType(type).template(), queryEngine.getSqmFunctionRegistry().patternTemplateBuilder(name, pattern3).setExactArgumentCount(3).setInvariantType(type).template()));
    }

    @Override
    protected <T> SelfRenderingSqmFunction<T> generateSqmFunctionExpression(List<SqmTypedNode<?>> arguments, AllowableFunctionReturnType<T> impliedResultType, QueryEngine queryEngine) {
        return (arguments.size() < 3 ? this.binaryFunction : this.ternaryFunction).makeSqmFunctionExpression(arguments, impliedResultType, queryEngine);
    }
}

