/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.query.sqm.sql.ConversionException;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class SqlAstProcessingStateImpl
implements SqlAstProcessingState,
SqlExpressionResolver {
    private final SqlAstProcessingState parentState;
    private final SqlAstCreationState creationState;
    private final Supplier<Clause> currentClauseAccess;
    private final Map<String, Expression> expressionMap = new HashMap<String, Expression>();

    public SqlAstProcessingStateImpl(SqlAstProcessingState parentState, SqlAstCreationState creationState, Supplier<Clause> currentClauseAccess) {
        this.parentState = parentState;
        this.creationState = creationState;
        this.currentClauseAccess = currentClauseAccess;
    }

    @Override
    public SqlAstProcessingState getParentState() {
        return this.parentState;
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this;
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this.creationState;
    }

    protected Map<Expression, SqlSelection> sqlSelectionMap() {
        return Collections.emptyMap();
    }

    @Override
    public Expression resolveSqlExpression(String key, Function<SqlAstProcessingState, Expression> creator) {
        Expression expression;
        Expression existing = this.expressionMap.get(key);
        if (existing != null) {
            expression = existing;
        } else {
            expression = creator.apply(this);
            this.expressionMap.put(key, expression);
        }
        Expression result = this.normalize(expression);
        return result;
    }

    protected Expression normalize(Expression expression) {
        SqlSelection selection;
        Clause currentClause = this.currentClauseAccess.get();
        if ((currentClause == Clause.ORDER || currentClause == Clause.GROUP || currentClause == Clause.HAVING) && (selection = this.sqlSelectionMap().get(expression)) != null) {
            return new SqlSelectionExpression(selection, expression);
        }
        return expression;
    }

    @Override
    public SqlSelection resolveSqlSelection(Expression expression, JavaTypeDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        throw new ConversionException("Unexpected call to resolve SqlSelection outside of QuerySpec processing");
    }

    @Override
    public SqlSelection emptySqlSelection() {
        throw new ConversionException("Unexpected call to resolve SqlSelection outside of QuerySpec processing");
    }
}

