/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.spi.SqlAstQuerySpecProcessingState;
import org.hibernate.sql.ast.spi.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.results.internal.EmptySqlSelection;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class SqlAstQuerySpecProcessingStateImpl
extends SqlAstProcessingStateImpl
implements SqlAstQuerySpecProcessingState {
    private final QuerySpec querySpec;
    private Map<Expression, SqlSelection> sqlSelectionMap;
    private int nonEmptySelections = 0;

    public SqlAstQuerySpecProcessingStateImpl(QuerySpec querySpec, SqlAstProcessingState parent, SqlAstCreationState creationState, Supplier<Clause> currentClauseAccess) {
        super(parent, creationState, currentClauseAccess);
        this.querySpec = querySpec;
    }

    @Override
    public QuerySpec getInflightQuerySpec() {
        return this.querySpec;
    }

    @Override
    protected Map<Expression, SqlSelection> sqlSelectionMap() {
        return this.sqlSelectionMap;
    }

    @Override
    public SqlSelection resolveSqlSelection(Expression expression, JavaTypeDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        SqlSelection existing;
        if (this.sqlSelectionMap == null) {
            this.sqlSelectionMap = new HashMap<Expression, SqlSelection>();
            existing = null;
        } else {
            existing = this.sqlSelectionMap.get(expression);
        }
        if (existing != null) {
            return existing;
        }
        SqlSelection sqlSelection = expression.createSqlSelection(this.nonEmptySelections + 1, this.sqlSelectionMap.size(), javaTypeDescriptor, typeConfiguration);
        this.sqlSelectionMap.put(expression, sqlSelection);
        if (!(sqlSelection instanceof EmptySqlSelection)) {
            ++this.nonEmptySelections;
        }
        this.querySpec.getSelectClause().addSqlSelection(sqlSelection);
        return sqlSelection;
    }

    @Override
    public SqlSelection emptySqlSelection() {
        EmptySqlSelection sqlSelection = new EmptySqlSelection(this.sqlSelectionMap.size());
        this.sqlSelectionMap.put(EmptyExpression.EMPTY_EXPRESSION, sqlSelection);
        return sqlSelection;
    }

    public static class EmptyExpression
    implements Expression {
        public static final EmptyExpression EMPTY_EXPRESSION = new EmptyExpression();

        private EmptyExpression() {
        }

        @Override
        public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, JavaTypeDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return null;
        }

        @Override
        public MappingModelExpressable getExpressionType() {
            return null;
        }

        @Override
        public void accept(SqlAstWalker sqlTreeWalker) {
        }
    }
}

