/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.List;
import java.util.function.Function;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.query.SemanticException;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.sql.ast.spi.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.results.internal.domain.basic.BasicResult;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;

public class SqmParameterInterpretation
implements Expression,
DomainResultProducer {
    private final SqmParameter sqmParameter;
    private final QueryParameterImplementor<?> queryParameter;
    private final MappingModelExpressable valueMapping;
    private final Function<QueryParameterImplementor, QueryParameterBinding> queryParameterBindingResolver;
    private final Expression resolvedExpression;

    public SqmParameterInterpretation(SqmParameter sqmParameter, QueryParameterImplementor<?> queryParameter, List<JdbcParameter> jdbcParameters, MappingModelExpressable valueMapping, Function<QueryParameterImplementor, QueryParameterBinding> queryParameterBindingResolver) {
        this.sqmParameter = sqmParameter;
        this.queryParameter = queryParameter;
        this.valueMapping = valueMapping;
        this.queryParameterBindingResolver = queryParameterBindingResolver;
        assert (jdbcParameters != null);
        assert (jdbcParameters.size() > 0);
        this.resolvedExpression = jdbcParameters.size() == 1 ? (Expression)jdbcParameters.get(0) : new SqlTuple(jdbcParameters, valueMapping);
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        this.resolvedExpression.accept(sqlTreeWalker);
    }

    @Override
    public MappingModelExpressable getExpressionType() {
        return this.valueMapping;
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        if (this.resolvedExpression instanceof SqlTuple) {
            throw new SemanticException("Composite query parameter cannot be used in select");
        }
        AllowableParameterType nodeType = this.sqmParameter.getNodeType();
        if (nodeType == null) {
            QueryParameterBinding binding = this.queryParameterBindingResolver.apply(this.queryParameter);
            nodeType = binding.getBindType();
        }
        SqlSelection sqlSelection = creationState.getSqlAstCreationState().getSqlExpressionResolver().resolveSqlSelection(this.resolvedExpression, nodeType.getExpressableJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, nodeType.getExpressableJavaTypeDescriptor());
    }
}

