/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.SqmInsertSelectTranslation;
import org.hibernate.query.sqm.sql.SqmInsertSelectTranslator;
import org.hibernate.query.sqm.sql.internal.SqlAstProcessingStateImpl;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.insert.SqmInsertSelectStatement;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;

public class StandardSqmInsertSelectTranslator
extends BaseSqmToSqlAstConverter
implements SqmInsertSelectTranslator {
    public StandardSqmInsertSelectTranslator(SqlAstCreationContext creationContext, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings) {
        super(creationContext, queryOptions, domainParameterXref, domainParameterBindings);
    }

    @Override
    public SqmInsertSelectTranslation translate(SqmInsertSelectStatement sqmStatement) {
        return new SqmInsertSelectTranslation(this.visitInsertSelectStatement(sqmStatement), this.getJdbcParamsBySqmParam());
    }

    @Override
    public CteStatement translate(SqmCteStatement sqmCte) {
        return this.visitCteStatement(sqmCte);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InsertSelectStatement visitInsertSelectStatement(SqmInsertSelectStatement sqmStatement) {
        InsertSelectStatement insertSelectStatement = new InsertSelectStatement();
        String entityName = ((SqmRoot)sqmStatement.getTarget()).getEntityName();
        EntityPersister entityDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(entityName);
        assert (entityDescriptor != null);
        this.getProcessingStateStack().push(new SqlAstProcessingStateImpl(null, this, this.getCurrentClauseStack()::getCurrent));
        try {
            NavigablePath rootPath = new NavigablePath(entityName);
            TableGroup rootTableGroup = entityDescriptor.createRootTableGroup(rootPath, null, JoinType.LEFT, LockMode.WRITE, stem -> this.getSqlAliasBaseGenerator().createSqlAliasBase(stem), this.getSqlExpressionResolver(), () -> predicate -> {
                this.additionalRestrictions = predicate;
            }, this.getCreationContext());
            if (!rootTableGroup.getTableReferenceJoins().isEmpty() || rootTableGroup.getTableGroupJoins().isEmpty()) {
                throw new HibernateException("Not expecting multiple table references for an SQM INSERT-SELECT");
            }
            this.getFromClauseIndex().registerTableGroup(rootPath, rootTableGroup);
            insertSelectStatement.setTargetTable(rootTableGroup.getPrimaryTableReference());
            insertSelectStatement.setSourceSelectStatement(this.visitQuerySpec(sqmStatement.getSelectQuerySpec()));
            InsertSelectStatement insertSelectStatement2 = insertSelectStatement;
            return insertSelectStatement2;
        }
        finally {
            this.getProcessingStateStack().pop();
        }
    }
}

