/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.sql.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.graph.AttributeNode;
import org.hibernate.graph.spi.GraphImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.DynamicInstantiationNature;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.sql.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.sql.SqmQuerySpecTranslation;
import org.hibernate.query.sqm.sql.SqmSelectTranslation;
import org.hibernate.query.sqm.sql.SqmSelectTranslator;
import org.hibernate.query.sqm.sql.internal.BasicValuedPathInterpretation;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.expression.SqmPathEntityType;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationTarget;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.expression.EntityTypeLiteral;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupJoinProducer;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.results.internal.domain.instantiation.DynamicInstantiation;
import org.hibernate.sql.results.spi.CircularFetchDetector;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.EntityResultNode;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.Fetchable;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class StandardSqmSelectTranslator
extends BaseSqmToSqlAstConverter
implements DomainResultCreationState,
SqmSelectTranslator {
    private final LoadQueryInfluencers fetchInfluencers;
    private final CircularFetchDetector circularFetchDetector = new CircularFetchDetector();
    private final List<DomainResult> domainResults = CollectionHelper.arrayList(10);
    private GraphImplementor<?> currentJpaGraphNode;
    private int fetchDepth = 0;

    public StandardSqmSelectTranslator(QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, LoadQueryInfluencers fetchInfluencers, SqlAstCreationContext creationContext) {
        super(creationContext, queryOptions, domainParameterXref, domainParameterBindings);
        this.fetchInfluencers = fetchInfluencers;
        if (fetchInfluencers != null && fetchInfluencers.getEffectiveEntityGraph().getSemantic() != null) {
            this.currentJpaGraphNode = fetchInfluencers.getEffectiveEntityGraph().getGraph();
        }
    }

    @Override
    public SqmSelectTranslation translate(SqmSelectStatement sqmStatement) {
        return new SqmSelectTranslation(this.visitSelectStatement(sqmStatement), this.getJdbcParamsBySqmParam());
    }

    @Override
    public SqmQuerySpecTranslation translate(SqmQuerySpec querySpec) {
        return new SqmQuerySpecTranslation(this.visitQuerySpec(querySpec), this.getJdbcParamsBySqmParam());
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this;
    }

    @Override
    public SelectStatement visitSelectStatement(SqmSelectStatement statement) {
        QuerySpec querySpec = this.visitQuerySpec((SqmQuerySpec)statement.getQuerySpec());
        return new SelectStatement(querySpec, this.domainResults);
    }

    @Override
    public Void visitSelection(SqmSelection sqmSelection) {
        DomainResultProducer resultProducer = this.resolveDomainResultProducer(sqmSelection);
        if (this.getProcessingStateStack().depth() > 1) {
            resultProducer.applySqlSelections(this);
        } else {
            DomainResult domainResult = resultProducer.createDomainResult(sqmSelection.getAlias(), this);
            this.domainResults.add(domainResult);
        }
        return null;
    }

    private DomainResultProducer resolveDomainResultProducer(SqmSelection sqmSelection) {
        return (DomainResultProducer)sqmSelection.getSelectableNode().accept(this);
    }

    @Override
    public List<org.hibernate.sql.results.spi.Fetch> visitFetches(final FetchParent fetchParent) {
        final ArrayList<org.hibernate.sql.results.spi.Fetch> fetches = CollectionHelper.arrayList(fetchParent.getReferencedMappingType().getNumberOfFetchables());
        Consumer<Fetchable> fetchableConsumer = new Consumer<Fetchable>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(Fetchable fetchable) {
                org.hibernate.sql.results.spi.Fetch biDirectionalFetch = StandardSqmSelectTranslator.this.circularFetchDetector.findBiDirectionalFetch(fetchParent, fetchable, StandardSqmSelectTranslator.this.getSqlAstCreationState().getCurrentProcessingState());
                if (biDirectionalFetch != null) {
                    fetches.add(biDirectionalFetch);
                    return;
                }
                try {
                    StandardSqmSelectTranslator.this.fetchDepth++;
                    org.hibernate.sql.results.spi.Fetch fetch = StandardSqmSelectTranslator.this.buildFetch(fetchParent, fetchable);
                    if (fetch != null) {
                        fetches.add(fetch);
                    }
                }
                finally {
                    StandardSqmSelectTranslator.this.fetchDepth--;
                }
            }
        };
        fetchParent.getReferencedMappingContainer().visitKeyFetchables(fetchableConsumer, null);
        fetchParent.getReferencedMappingContainer().visitFetchables(fetchableConsumer, null);
        return fetches;
    }

    private org.hibernate.sql.results.spi.Fetch buildFetch(FetchParent fetchParent, Fetchable fetchable) {
        Object existingJoinedGroup;
        String alias;
        NavigablePath fetchablePath = fetchParent.getNavigablePath().append(fetchable.getFetchableName());
        GraphImplementor<?> previousGraphNode = this.currentJpaGraphNode;
        LockMode lockMode = LockMode.READ;
        FetchTiming fetchTiming = fetchable.getMappedFetchStrategy().getTiming();
        boolean joined = false;
        SqmAttributeJoin fetchedJoin = this.getFromClauseIndex().findFetchedJoinByPath(fetchablePath);
        if (fetchedJoin != null) {
            assert (this.getFromClauseIndex().getTableGroup(fetchablePath) != null);
            if (fetchedJoin.isFetched()) {
                fetchTiming = FetchTiming.IMMEDIATE;
            }
            joined = true;
            alias = fetchedJoin.getExplicitAlias();
            lockMode = this.determineLockMode(alias);
        } else {
            Integer maxDepth;
            alias = null;
            if (this.currentJpaGraphNode != null && StandardSqmSelectTranslator.appliesTo(this.currentJpaGraphNode, fetchParent)) {
                AttributeNode attributeNode = this.currentJpaGraphNode.findAttributeNode(fetchable.getFetchableName());
                if (attributeNode != null) {
                    fetchTiming = FetchTiming.IMMEDIATE;
                    joined = true;
                }
            } else if (this.fetchInfluencers.hasEnabledFetchProfiles() && fetchParent instanceof EntityResultNode) {
                EntityResultNode entityFetchParent = (EntityResultNode)fetchParent;
                EntityMappingType entityMappingType = entityFetchParent.getEntityValuedModelPart().getEntityMappingType();
                String fetchParentEntityName = entityMappingType.getEntityName();
                String fetchableRole = fetchParentEntityName + "." + fetchable.getFetchableName();
                for (String enabledFetchProfileName : this.fetchInfluencers.getEnabledFetchProfileNames()) {
                    FetchProfile enabledFetchProfile = this.getCreationContext().getSessionFactory().getFetchProfile(enabledFetchProfileName);
                    Fetch profileFetch = enabledFetchProfile.getFetchByRole(fetchableRole);
                    fetchTiming = FetchTiming.IMMEDIATE;
                    joined = joined || profileFetch.getStyle() == Fetch.Style.JOIN;
                }
            }
            existingJoinedGroup = this.getFromClauseIndex().findTableGroup(fetchablePath);
            if (existingJoinedGroup != null) {
                // empty if block
            }
            if ((maxDepth = this.getCreationContext().getMaximumFetchDepth()) != null) {
                if (this.fetchDepth == maxDepth) {
                    joined = false;
                } else if (this.fetchDepth > maxDepth) {
                    return null;
                }
            }
            if (joined && fetchable instanceof TableGroupJoinProducer) {
                this.getFromClauseIndex().resolveTableGroup(fetchablePath, np -> {
                    TableGroup lhs = this.getFromClauseIndex().getTableGroup(fetchParent.getNavigablePath());
                    TableGroupJoin tableGroupJoin = ((TableGroupJoinProducer)((Object)fetchable)).createTableGroupJoin(fetchablePath, lhs, alias, JoinType.LEFT, LockMode.NONE, this.getSqlAliasBaseManager(), this.getSqlExpressionResolver(), this.getCreationContext());
                    lhs.addTableGroupJoin(tableGroupJoin);
                    return tableGroupJoin.getJoinedGroup();
                });
            }
        }
        try {
            existingJoinedGroup = fetchable.generateFetch(fetchParent, fetchablePath, fetchTiming, joined, lockMode, alias, this);
            return existingJoinedGroup;
        }
        catch (RuntimeException e) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not generate fetch : %s -> %s", fetchParent.getNavigablePath(), fetchable.getFetchableName()), e);
        }
        finally {
            this.currentJpaGraphNode = previousGraphNode;
        }
    }

    private static boolean appliesTo(GraphImplementor<?> graphNode, FetchParent fetchParent) {
        if (!(fetchParent instanceof EntityResultNode)) {
            return false;
        }
        EntityResultNode entityFetchParent = (EntityResultNode)fetchParent;
        EntityMappingType entityFetchParentMappingType = entityFetchParent.getEntityValuedModelPart().getEntityMappingType();
        assert (graphNode.getGraphedType() instanceof EntityDomainType);
        EntityDomainType entityDomainType = (EntityDomainType)graphNode.getGraphedType();
        return entityDomainType.getHibernateEntityName().equals(entityFetchParentMappingType.getEntityName());
    }

    @Override
    public FromClauseAccess getFromClauseAccess() {
        return this.getFromClauseIndex();
    }

    @Override
    public LockMode determineLockMode(String identificationVariable) {
        LockOptions lockOptions = this.getQueryOptions().getLockOptions();
        return lockOptions.getScope() || identificationVariable == null ? lockOptions.getLockMode() : lockOptions.getEffectiveLockMode(identificationVariable);
    }

    @Override
    public DynamicInstantiation visitDynamicInstantiation(SqmDynamicInstantiation<?> sqmDynamicInstantiation) {
        SqmDynamicInstantiationTarget<?> instantiationTarget = sqmDynamicInstantiation.getInstantiationTarget();
        DynamicInstantiationNature instantiationNature = instantiationTarget.getNature();
        JavaTypeDescriptor targetTypeDescriptor = this.interpretInstantiationTarget(instantiationTarget);
        DynamicInstantiation dynamicInstantiation = new DynamicInstantiation(instantiationNature, targetTypeDescriptor);
        for (SqmDynamicInstantiationArgument<?> sqmArgument : sqmDynamicInstantiation.getArguments()) {
            DomainResultProducer argumentResultProducer = (DomainResultProducer)sqmArgument.getSelectableNode().accept(this);
            dynamicInstantiation.addArgument(sqmArgument.getAlias(), argumentResultProducer);
        }
        dynamicInstantiation.complete();
        return dynamicInstantiation;
    }

    private <T> JavaTypeDescriptor<T> interpretInstantiationTarget(SqmDynamicInstantiationTarget instantiationTarget) {
        Class targetJavaType = instantiationTarget.getNature() == DynamicInstantiationNature.LIST ? List.class : (instantiationTarget.getNature() == DynamicInstantiationNature.MAP ? Map.class : instantiationTarget.getJavaType());
        return this.getCreationContext().getDomainModel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(targetJavaType);
    }

    @Override
    public Expression visitEntityTypeLiteralExpression(SqmLiteralEntityType sqmExpression) {
        SqmExpressable nodeType = sqmExpression.getNodeType();
        EntityPersister mappingDescriptor = this.getCreationContext().getDomainModel().getEntityDescriptor(nodeType.getHibernateEntityName());
        return new EntityTypeLiteral(mappingDescriptor);
    }

    @Override
    public Expression visitSqmPathEntityTypeExpression(SqmPathEntityType<?> sqmExpression) {
        return BasicValuedPathInterpretation.from(sqmExpression, this, this);
    }

    @Override
    public Object visitFullyQualifiedClass(Class namedClass) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public CteStatement translate(SqmCteStatement sqmCte) {
        return this.visitCteStatement(sqmCte);
    }
}

