/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree;

import org.hibernate.sql.ast.JoinType;

public enum SqmJoinType {
    INNER("inner", JoinType.INNER, javax.persistence.criteria.JoinType.INNER),
    LEFT("left outer", JoinType.LEFT, javax.persistence.criteria.JoinType.LEFT),
    RIGHT("right outer", JoinType.RIGHT, javax.persistence.criteria.JoinType.RIGHT),
    CROSS("cross", JoinType.CROSS, null),
    FULL("full", JoinType.FULL, null);

    private final String text;
    private final JoinType correspondingSqlJoinType;
    private final javax.persistence.criteria.JoinType correspondingJpaJoinType;

    private SqmJoinType(String text, JoinType correspondingSqlJoinType, javax.persistence.criteria.JoinType correspondingJpaJoinType) {
        this.text = text;
        this.correspondingSqlJoinType = correspondingSqlJoinType;
        this.correspondingJpaJoinType = correspondingJpaJoinType;
    }

    public String toString() {
        return this.text;
    }

    public String getText() {
        return this.text;
    }

    public JoinType getCorrespondingSqlJoinType() {
        return this.correspondingSqlJoinType;
    }

    public javax.persistence.criteria.JoinType getCorrespondingJpaJoinType() {
        return this.correspondingJpaJoinType;
    }

    public static SqmJoinType from(javax.persistence.criteria.JoinType jpaJoinType) {
        switch (jpaJoinType) {
            case INNER: {
                return INNER;
            }
            case LEFT: {
                return LEFT;
            }
            case RIGHT: {
                return RIGHT;
            }
        }
        return INNER;
    }
}

