/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.metamodel.CollectionAttribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SetAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.BagPersistentAttribute;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.ListPersistentAttribute;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.metamodel.model.domain.SetPersistentAttribute;
import org.hibernate.metamodel.model.domain.SingularPersistentAttribute;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaPath;
import org.hibernate.query.criteria.JpaSubQuery;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.UnknownPathException;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPath;
import org.hibernate.query.sqm.tree.domain.SqmBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;

public abstract class AbstractSqmFrom<O, T>
extends AbstractSqmPath<T>
implements SqmFrom<O, T> {
    private String alias;
    private SqmFrom<O, T> correlationParent;
    private List<SqmJoin<T, ?>> joins;

    protected AbstractSqmFrom(NavigablePath navigablePath, SqmPathSource<T> referencedNavigable, SqmFrom lhs, String alias, NodeBuilder nodeBuilder) {
        super(navigablePath, referencedNavigable, lhs, nodeBuilder);
        if (lhs == null) {
            throw new IllegalArgumentException("LHS cannot be null");
        }
        this.alias = alias;
    }

    protected AbstractSqmFrom(EntityDomainType<T> entityType, String alias, NodeBuilder nodeBuilder) {
        super(SqmCreationHelper.buildRootNavigablePath(entityType.getHibernateEntityName(), alias), entityType, null, nodeBuilder);
        this.alias = alias;
    }

    @Override
    public String getExplicitAlias() {
        return this.alias;
    }

    @Override
    public void setExplicitAlias(String explicitAlias) {
        this.alias = explicitAlias;
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        NavigablePath subNavPath = this.getNavigablePath().append(name);
        return creationState.getProcessingStateStack().getCurrent().getPathRegistry().resolvePath(subNavPath, snp -> {
            SqmPathSource<?> subSource = this.getReferencedPathSource().findSubPathSource(name);
            if (subSource == null) {
                throw UnknownPathException.unknownSubPath(this, name);
            }
            return subSource.createSqmPath(this, creationState);
        });
    }

    @Override
    public boolean hasJoins() {
        return this.joins != null && !this.joins.isEmpty();
    }

    @Override
    public List<SqmJoin<T, ?>> getSqmJoins() {
        return this.joins == null ? Collections.emptyList() : Collections.unmodifiableList(this.joins);
    }

    @Override
    public void addSqmJoin(SqmJoin<T, ?> join) {
        if (this.joins == null) {
            this.joins = new ArrayList();
        }
        this.joins.add(join);
    }

    @Override
    public void visitSqmJoins(Consumer<SqmJoin<T, ?>> consumer) {
        if (this.joins != null) {
            this.joins.forEach(consumer);
        }
    }

    @Override
    public JpaPath getParentPath() {
        return this.getLhs();
    }

    @Override
    public SqmFrom<O, T> getCorrelationParent() {
        return this.correlationParent;
    }

    public boolean isCorrelated() {
        return false;
    }

    @Override
    public SqmFrom<O, T> correlateTo(JpaSubQuery<T> subquery) {
        throw new NotYetImplementedFor6Exception();
    }

    public Set<Join<T, ?>> getJoins() {
        return this.getSqmJoins().stream().filter(sqmJoin -> !(sqmJoin instanceof SqmAttributeJoin) || !((SqmAttributeJoin)sqmJoin).isFetched()).collect(Collectors.toSet());
    }

    @Override
    public <A> SqmSingularJoin<T, A> join(SingularAttribute<? super T, A> attribute) {
        return this.join((SingularAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <A> SqmSingularJoin<T, A> join(SingularAttribute<? super T, A> attribute, JoinType jt) {
        return this.buildSingularJoin((SingularPersistentAttribute)attribute, SqmJoinType.from(jt), false);
    }

    @Override
    public <A> SqmBagJoin<T, A> join(CollectionAttribute<? super T, A> attribute) {
        return this.join((CollectionAttribute)attribute, JoinType.INNER);
    }

    @Override
    public SqmBagJoin join(CollectionAttribute attribute, JoinType jt) {
        return this.buildBagJoin((BagPersistentAttribute)attribute, SqmJoinType.from(jt), false);
    }

    @Override
    public SqmSetJoin join(SetAttribute attribute) {
        return this.join(attribute, JoinType.INNER);
    }

    @Override
    public SqmSetJoin join(SetAttribute attribute, JoinType jt) {
        return this.buildSetJoin((SetPersistentAttribute)attribute, SqmJoinType.from(jt), false);
    }

    @Override
    public SqmListJoin join(ListAttribute attribute) {
        return this.join(attribute, JoinType.INNER);
    }

    @Override
    public SqmListJoin join(ListAttribute attribute, JoinType jt) {
        return this.buildListJoin((ListPersistentAttribute)attribute, SqmJoinType.from(jt), false);
    }

    @Override
    public SqmMapJoin join(MapAttribute attribute) {
        return this.join(attribute, JoinType.INNER);
    }

    @Override
    public SqmMapJoin join(MapAttribute attribute, JoinType jt) {
        return this.buildMapJoin((MapPersistentAttribute)attribute, SqmJoinType.from(jt), false);
    }

    @Override
    public SqmAttributeJoin join(String attributeName) {
        return this.join(attributeName, JoinType.INNER);
    }

    @Override
    public SqmAttributeJoin join(String attributeName, JoinType jt) {
        SqmPathSource<?> subPathSource = this.getReferencedPathSource().findSubPathSource(attributeName);
        return this.buildJoin(subPathSource, SqmJoinType.from(jt), false);
    }

    public SqmBagJoin joinCollection(String attributeName) {
        return this.joinCollection(attributeName, JoinType.INNER);
    }

    @Override
    public SqmBagJoin joinCollection(String attributeName, JoinType jt) {
        SqmPathSource<?> joinedPathSource = this.getReferencedPathSource().findSubPathSource(attributeName);
        if (joinedPathSource instanceof BagPersistentAttribute) {
            return this.buildBagJoin((BagPersistentAttribute)joinedPathSource, SqmJoinType.from(jt), false);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute name [%s] did not correspond to a collection (bag) reference [%s] relative to %s", attributeName, joinedPathSource, this.getNavigablePath().getFullPath()));
    }

    public SqmSetJoin joinSet(String attributeName) {
        return this.joinSet(attributeName, JoinType.INNER);
    }

    @Override
    public SqmSetJoin joinSet(String attributeName, JoinType jt) {
        SqmPathSource<?> joinedPathSource = this.getReferencedPathSource().findSubPathSource(attributeName);
        if (joinedPathSource instanceof SetPersistentAttribute) {
            return this.buildSetJoin((SetPersistentAttribute)joinedPathSource, SqmJoinType.from(jt), false);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute name [%s] did not correspond to a collection (set) reference [%s] relative to %s", attributeName, joinedPathSource, this.getNavigablePath().getFullPath()));
    }

    public SqmListJoin joinList(String attributeName) {
        return this.joinList(attributeName, JoinType.INNER);
    }

    @Override
    public SqmListJoin joinList(String attributeName, JoinType jt) {
        SqmPathSource<?> joinedPathSource = this.getReferencedPathSource().findSubPathSource(attributeName);
        if (joinedPathSource instanceof ListPersistentAttribute) {
            return this.buildListJoin((ListPersistentAttribute)joinedPathSource, SqmJoinType.from(jt), false);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute name [%s] did not correspond to a collection (list) reference [%s] relative to %s", attributeName, joinedPathSource, this.getNavigablePath().getFullPath()));
    }

    public SqmMapJoin joinMap(String attributeName) {
        return this.joinMap(attributeName, JoinType.INNER);
    }

    @Override
    public SqmMapJoin joinMap(String attributeName, JoinType jt) {
        SqmPathSource<?> joinedPathSource = this.getReferencedPathSource().findSubPathSource(attributeName);
        if (joinedPathSource instanceof MapPersistentAttribute) {
            return this.buildMapJoin((MapPersistentAttribute)joinedPathSource, SqmJoinType.from(jt), false);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute name [%s] did not correspond to a collection (map) reference [%s] relative to %s", attributeName, joinedPathSource, this.getNavigablePath().getFullPath()));
    }

    @Override
    public Set<Fetch<T, ?>> getFetches() {
        return this.getSqmJoins().stream().filter(sqmJoin -> sqmJoin instanceof SqmAttributeJoin && ((SqmAttributeJoin)sqmJoin).isFetched()).collect(Collectors.toSet());
    }

    @Override
    public <A> SqmSingularJoin<T, A> fetch(SingularAttribute<? super T, A> attribute) {
        return this.fetch((SingularAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <A> SqmSingularJoin<T, A> fetch(SingularAttribute<? super T, A> attribute, JoinType jt) {
        return this.buildSingularJoin((SingularPersistentAttribute)attribute, SqmJoinType.from(jt), true);
    }

    @Override
    public <A> SqmAttributeJoin<T, A> fetch(PluralAttribute<? super T, ?, A> attribute) {
        return this.fetch((PluralAttribute)attribute, JoinType.INNER);
    }

    @Override
    public <A> SqmAttributeJoin<T, A> fetch(PluralAttribute<? super T, ?, A> attribute, JoinType jt) {
        return this.buildJoin((PluralPersistentAttribute)attribute, SqmJoinType.from(jt), true);
    }

    @Override
    public <X, A> SqmAttributeJoin<X, A> fetch(String attributeName) {
        return this.fetch(attributeName, JoinType.INNER);
    }

    @Override
    public <X, A> SqmAttributeJoin<X, A> fetch(String attributeName, JoinType jt) {
        SqmPathSource<?> fetchedPathSource = this.getReferencedPathSource().findSubPathSource(attributeName);
        return this.buildJoin(fetchedPathSource, SqmJoinType.from(jt), true);
    }

    private <A> SqmAttributeJoin buildJoin(SqmPathSource<A> joinedPathSource, SqmJoinType joinType, boolean fetched) {
        if (joinedPathSource instanceof SingularPersistentAttribute) {
            return this.buildSingularJoin((SingularPersistentAttribute)joinedPathSource, joinType, fetched);
        }
        if (joinedPathSource instanceof BagPersistentAttribute) {
            return this.buildBagJoin((BagPersistentAttribute)joinedPathSource, joinType, fetched);
        }
        if (joinedPathSource instanceof ListPersistentAttribute) {
            return this.buildListJoin((ListPersistentAttribute)joinedPathSource, joinType, fetched);
        }
        if (joinedPathSource instanceof MapPersistentAttribute) {
            return this.buildMapJoin((MapPersistentAttribute)joinedPathSource, joinType, fetched);
        }
        if (joinedPathSource instanceof SetPersistentAttribute) {
            return this.buildSetJoin((SetPersistentAttribute)joinedPathSource, joinType, fetched);
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Passed attribute [%s] did not correspond to a joinable reference [%s] relative to %s", joinedPathSource.getPathName(), joinedPathSource, this.getNavigablePath().getFullPath()));
    }

    private <A> SqmSingularJoin<T, A> buildSingularJoin(SingularPersistentAttribute<T, A> attribute, SqmJoinType joinType, boolean fetched) {
        if (attribute.getSqmPathType() instanceof ManagedDomainType) {
            return new SqmSingularJoin<T, A>(this, attribute, null, joinType, fetched, this.nodeBuilder());
        }
        throw new SemanticException("Attribute [" + attribute + "] is not joinable");
    }

    private <E> SqmBagJoin<T, E> buildBagJoin(BagPersistentAttribute attribute, SqmJoinType joinType, boolean fetched) {
        return new SqmBagJoin(this, attribute, null, joinType, fetched, this.nodeBuilder());
    }

    private <E> SqmListJoin<T, E> buildListJoin(ListPersistentAttribute attribute, SqmJoinType joinType, boolean fetched) {
        return new SqmListJoin(this, attribute, null, joinType, fetched, this.nodeBuilder());
    }

    private <K, V> SqmMapJoin<T, K, V> buildMapJoin(MapPersistentAttribute attribute, SqmJoinType joinType, boolean fetched) {
        return new SqmMapJoin(this, attribute, null, joinType, fetched, this.nodeBuilder());
    }

    private <E> SqmSetJoin<T, E> buildSetJoin(SetPersistentAttribute attribute, SqmJoinType joinType, boolean fetched) {
        return new SqmSetJoin(this, attribute, null, joinType, fetched, this.nodeBuilder());
    }
}

