/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import org.hibernate.metamodel.model.domain.BasicDomainType;
import org.hibernate.metamodel.model.domain.EmbeddableDomainType;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.PathException;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaMapJoin;
import org.hibernate.query.criteria.JpaPredicate;
import org.hibernate.query.criteria.JpaSubQuery;
import org.hibernate.query.hql.spi.SqmCreationProcessingState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.SqmJoinType;
import org.hibernate.query.sqm.tree.domain.AbstractSqmPluralJoin;
import org.hibernate.query.sqm.tree.domain.SqmBasicValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEmbeddedValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmEntityValuedSimplePath;
import org.hibernate.query.sqm.tree.domain.SqmMapEntryReference;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.domain.SqmTreatedMapJoin;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class SqmMapJoin<O, K, V>
extends AbstractSqmPluralJoin<O, Map<K, V>, V>
implements JpaMapJoin<O, K, V> {
    public SqmMapJoin(SqmFrom<?, O> lhs, MapPersistentAttribute<O, K, V> pluralValuedNavigable, String alias, SqmJoinType sqmJoinType, boolean fetched, NodeBuilder nodeBuilder) {
        super(lhs, pluralValuedNavigable, alias, sqmJoinType, fetched, nodeBuilder);
    }

    @Override
    public MapPersistentAttribute<O, K, V> getReferencedPathSource() {
        return (MapPersistentAttribute)super.getReferencedPathSource();
    }

    @Override
    public JavaTypeDescriptor<V> getJavaTypeDescriptor() {
        return this.getNodeJavaTypeDescriptor();
    }

    @Override
    public MapPersistentAttribute<O, K, V> getModel() {
        return (MapPersistentAttribute)super.getModel();
    }

    public SqmPath<K> key() {
        SqmPathSource keyPathSource = this.getReferencedPathSource().getKeyPathSource();
        NavigablePath navigablePath = this.getNavigablePath().append(keyPathSource.getPathName());
        if (keyPathSource.getSqmPathType() instanceof BasicDomainType) {
            return new SqmBasicValuedSimplePath(navigablePath, keyPathSource, (SqmPath)this, null);
        }
        if (keyPathSource.getSqmPathType() instanceof EmbeddableDomainType) {
            return new SqmEmbeddedValuedSimplePath(navigablePath, keyPathSource, (SqmPath)this, null);
        }
        if (keyPathSource.getSqmPathType() instanceof EntityDomainType) {
            return new SqmEntityValuedSimplePath(navigablePath, keyPathSource, (SqmPath)this, null);
        }
        throw new UnsupportedOperationException("Unrecognized Map key descriptor : " + keyPathSource);
    }

    public Path<V> value() {
        SqmPathSource elementPathSource = this.getReferencedPathSource().getElementPathSource();
        NavigablePath navigablePath = this.getNavigablePath().append(elementPathSource.getPathName());
        if (elementPathSource.getSqmPathType() instanceof BasicDomainType) {
            return new SqmBasicValuedSimplePath(navigablePath, elementPathSource, (SqmPath)this, null);
        }
        if (elementPathSource.getSqmPathType() instanceof EmbeddableDomainType) {
            return new SqmEmbeddedValuedSimplePath(navigablePath, elementPathSource, (SqmPath)this, null);
        }
        if (elementPathSource.getSqmPathType() instanceof EntityDomainType) {
            return new SqmEntityValuedSimplePath(navigablePath, elementPathSource, (SqmPath)this, null);
        }
        throw new UnsupportedOperationException("Unrecognized Map value descriptor : " + elementPathSource);
    }

    public Expression<Map.Entry<K, V>> entry() {
        return new SqmMapEntryReference(this, this.nodeBuilder());
    }

    @Override
    public SqmMapJoin<O, K, V> on(JpaExpression<Boolean> restriction) {
        return (SqmMapJoin)super.on((JpaExpression)restriction);
    }

    @Override
    public SqmMapJoin<O, K, V> on(Expression<Boolean> restriction) {
        return (SqmMapJoin)super.on((Expression)restriction);
    }

    @Override
    public SqmMapJoin<O, K, V> on(JpaPredicate ... restrictions) {
        return (SqmMapJoin)super.on(restrictions);
    }

    @Override
    public SqmMapJoin<O, K, V> on(Predicate ... restrictions) {
        return (SqmMapJoin)super.on(restrictions);
    }

    @Override
    public SqmMapJoin<O, K, V> correlateTo(JpaSubQuery<V> subquery) {
        return (SqmMapJoin)super.correlateTo((JpaSubQuery)subquery);
    }

    public <S extends V> SqmTreatedMapJoin<O, K, V, S> treatAs(Class<S> treatJavaType) throws PathException {
        return this.treatAs((EntityDomainType)this.nodeBuilder().getDomainModel().entity(treatJavaType));
    }

    public <S extends V> SqmTreatedMapJoin<O, K, V, S> treatAs(EntityDomainType<S> treatTarget) throws PathException {
        return new SqmTreatedMapJoin(this, treatTarget, null);
    }

    @Override
    public SqmAttributeJoin makeCopy(SqmCreationProcessingState creationProcessingState) {
        return new SqmMapJoin<O, K, V>(creationProcessingState.getPathRegistry().findFromByPath(this.getLhs().getNavigablePath()), this.getReferencedPathSource(), this.getExplicitAlias(), this.getSqmJoinType(), this.isFetched(), this.nodeBuilder());
    }
}

