/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.domain;

import org.hibernate.metamodel.model.domain.ListPersistentAttribute;
import org.hibernate.metamodel.model.domain.MapPersistentAttribute;
import org.hibernate.metamodel.model.domain.PluralPersistentAttribute;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmPathSource;
import org.hibernate.query.sqm.tree.domain.AbstractSqmSpecificPluralPartPath;
import org.hibernate.query.sqm.tree.domain.SqmPath;

public class SqmMaxIndexPath<T>
extends AbstractSqmSpecificPluralPartPath<T> {
    public static final String NAVIGABLE_NAME = "{max-index}";
    private final SqmPathSource<T> indexPathSource;

    public SqmMaxIndexPath(SqmPath<?> pluralDomainPath) {
        super(pluralDomainPath.getNavigablePath().append(NAVIGABLE_NAME), pluralDomainPath, (PluralPersistentAttribute)pluralDomainPath.getReferencedPathSource());
        if (this.getPluralAttribute() instanceof ListPersistentAttribute) {
            this.indexPathSource = ((ListPersistentAttribute)this.getPluralAttribute()).getIndexPathSource();
        } else if (this.getPluralAttribute() instanceof MapPersistentAttribute) {
            this.indexPathSource = ((MapPersistentAttribute)this.getPluralAttribute()).getKeyPathSource();
        } else {
            throw new UnsupportedOperationException("Plural attribute [" + this.getPluralAttribute() + "] is not indexed");
        }
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        return this.indexPathSource.createSqmPath(this, creationState);
    }

    @Override
    public SqmPathSource<T> getReferencedPathSource() {
        return this.indexPathSource;
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitMaxIndexPath(this);
    }
}

