/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaSearchedCase;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.query.sqm.tree.expression.AbstractSqmExpression;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;

public class SqmCaseSearched<R>
extends AbstractSqmExpression<R>
implements JpaSearchedCase<R>,
DomainResultProducer<R> {
    private List<WhenFragment<R>> whenFragments = new ArrayList<WhenFragment<R>>();
    private SqmExpression<R> otherwise;

    public SqmCaseSearched(NodeBuilder nodeBuilder) {
        this((SqmExpressable<R>)null, nodeBuilder);
    }

    public SqmCaseSearched(SqmExpressable<R> inherentType, NodeBuilder nodeBuilder) {
        super(inherentType, nodeBuilder);
    }

    public List<WhenFragment<R>> getWhenFragments() {
        return this.whenFragments;
    }

    public SqmExpression<R> getOtherwise() {
        return this.otherwise;
    }

    public void when(SqmPredicate predicate, SqmExpression<R> result) {
        this.whenFragments.add(new WhenFragment<R>(predicate, result));
        this.applyInferableType(result.getNodeType());
    }

    public void otherwise(SqmExpression<R> otherwiseExpression) {
        this.otherwise = otherwiseExpression;
        this.applyInferableType(otherwiseExpression.getNodeType());
    }

    @Override
    protected void internalApplyInferableType(SqmExpressable<?> newType) {
        super.internalApplyInferableType(newType);
        if (this.otherwise != null) {
            this.otherwise.applyInferableType(newType);
        }
        if (this.whenFragments != null) {
            this.whenFragments.forEach(whenFragment -> whenFragment.getResult().applyInferableType(newType));
        }
    }

    public <T> T accept(SemanticQueryWalker<T> walker) {
        return walker.visitSearchedCaseExpression(this);
    }

    @Override
    public String asLoggableText() {
        return "<searched-case>";
    }

    @Override
    public SqmCaseSearched<R> when(Expression<Boolean> condition, R result) {
        this.when((SqmPredicate)this.nodeBuilder().wrap((Expression)condition), (SqmExpression<R>)this.nodeBuilder().literal(result));
        return this;
    }

    @Override
    public JpaSearchedCase<R> when(Expression<Boolean> condition, Expression<? extends R> result) {
        this.when((SqmPredicate)this.nodeBuilder().wrap((Expression)condition), (SqmExpression)result);
        return this;
    }

    @Override
    public JpaExpression<R> otherwise(R result) {
        this.otherwise((SqmExpression<R>)this.nodeBuilder().literal(result));
        return this;
    }

    @Override
    public JpaExpression<R> otherwise(Expression<? extends R> result) {
        this.otherwise((SqmExpression)result);
        return this;
    }

    public static class WhenFragment<R> {
        private final SqmPredicate predicate;
        private final SqmExpression<R> result;

        public WhenFragment(SqmPredicate predicate, SqmExpression<R> result) {
            this.predicate = predicate;
            this.result = result;
        }

        public SqmPredicate getPredicate() {
            return this.predicate;
        }

        public SqmExpression<R> getResult() {
            return this.result;
        }
    }
}

