/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.expression;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.persistence.criteria.Expression;
import org.hibernate.query.SemanticException;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class SqmEnumLiteral
implements SqmExpression<Enum>,
SqmExpressable<Enum>,
SemanticPathPart {
    private final Enum enumValue;
    private final EnumJavaTypeDescriptor<Enum> referencedEnumTypeDescriptor;
    private final String enumValueName;
    private final NodeBuilder nodeBuilder;
    private SqmExpressable<Enum> expressable;

    public SqmEnumLiteral(Enum enumValue, EnumJavaTypeDescriptor<Enum> referencedEnumTypeDescriptor, String enumValueName, NodeBuilder nodeBuilder) {
        this.enumValue = enumValue;
        this.referencedEnumTypeDescriptor = referencedEnumTypeDescriptor;
        this.enumValueName = enumValueName;
        this.nodeBuilder = nodeBuilder;
        this.expressable = this;
    }

    public Enum getEnumValue() {
        return this.enumValue;
    }

    public String getEnumValueName() {
        return this.enumValueName;
    }

    @Override
    public EnumJavaTypeDescriptor<Enum> getExpressableJavaTypeDescriptor() {
        return this.referencedEnumTypeDescriptor;
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        throw new SemanticException(String.format(Locale.ROOT, "Static enum reference [%s#%s] cannot be de-referenced", this.referencedEnumTypeDescriptor.getJavaType().getName(), this.enumValueName));
    }

    @Override
    public SqmPath resolveIndexedAccess(SqmExpression selector, boolean isTerminal, SqmCreationState creationState) {
        throw new SemanticException(String.format(Locale.ROOT, "Static enum reference [%s#%s] cannot be de-referenced", this.referencedEnumTypeDescriptor.getJavaType().getName(), this.enumValueName));
    }

    @Override
    public SqmExpressable<Enum> getNodeType() {
        return this.expressable;
    }

    @Override
    public void applyInferableType(SqmExpressable<?> type) {
    }

    @Override
    public SqmExpression<Long> asLong() {
        return this.nodeBuilder().literal((Object)((EnumJavaTypeDescriptor)this.getExpressableJavaTypeDescriptor()).toOrdinal(this.enumValue).longValue());
    }

    @Override
    public SqmExpression<Integer> asInteger() {
        return this.nodeBuilder().literal(((EnumJavaTypeDescriptor)this.getExpressableJavaTypeDescriptor()).toOrdinal(this.enumValue));
    }

    @Override
    public SqmExpression<Float> asFloat() {
        return this.nodeBuilder().literal(Float.valueOf(((EnumJavaTypeDescriptor)this.getExpressableJavaTypeDescriptor()).toOrdinal(this.enumValue).floatValue()));
    }

    @Override
    public SqmExpression<Double> asDouble() {
        return this.nodeBuilder().literal((Object)((EnumJavaTypeDescriptor)this.getExpressableJavaTypeDescriptor()).toOrdinal(this.enumValue).doubleValue());
    }

    @Override
    public SqmExpression<BigDecimal> asBigDecimal() {
        throw new UnsupportedOperationException("Enum literal cannot be cast to BigDecimal");
    }

    @Override
    public SqmExpression<BigInteger> asBigInteger() {
        throw new UnsupportedOperationException("Enum literal cannot be cast to BigInteger");
    }

    @Override
    public SqmExpression<String> asString() {
        return this.nodeBuilder().literal(((EnumJavaTypeDescriptor)this.getExpressableJavaTypeDescriptor()).toName(this.enumValue));
    }

    @Override
    public <X> SqmExpression<X> as(Class<X> type) {
        return this.nodeBuilder().cast((JpaExpression)this, (Class)type);
    }

    @Override
    public SqmPredicate isNull() {
        return this.nodeBuilder().isNull(this);
    }

    @Override
    public SqmPredicate isNotNull() {
        return this.nodeBuilder().isNotNull(this);
    }

    @Override
    public SqmPredicate in(Object ... values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmPredicate in(Expression<?> ... values) {
        return this.nodeBuilder().in((Expression)this, (Expression[])values);
    }

    @Override
    public SqmPredicate in(Collection<?> values) {
        return this.nodeBuilder().in((Expression)this, new Object[]{values});
    }

    @Override
    public SqmPredicate in(Expression<Collection<?>> values) {
        return this.nodeBuilder().in((Expression)this, new Expression[]{values});
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitEnumLiteral(this);
    }

    @Override
    public JavaTypeDescriptor<Enum> getJavaTypeDescriptor() {
        return this.getExpressableJavaTypeDescriptor();
    }

    @Override
    public NodeBuilder nodeBuilder() {
        return this.nodeBuilder;
    }

    @Override
    public List<? extends JpaSelection<?>> getSelectionItems() {
        throw new IllegalStateException("Not a compound selection");
    }

    public boolean isCompoundSelection() {
        return false;
    }

    @Override
    public JpaSelection<Enum> alias(String name) {
        return null;
    }

    public String getAlias() {
        return null;
    }
}

