/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.from;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public class SqmFromClause {
    private List<SqmRoot> domainRoots;

    public SqmFromClause() {
    }

    public SqmFromClause(int expectedNumberOfRoots) {
        this.domainRoots = CollectionHelper.arrayList(expectedNumberOfRoots);
    }

    public List<SqmRoot> getRoots() {
        return this.domainRoots == null ? Collections.emptyList() : Collections.unmodifiableList(this.domainRoots);
    }

    public void setRoots(List<SqmRoot> domainRoots) {
        this.domainRoots = domainRoots;
    }

    public void addRoot(SqmRoot root) {
        if (this.domainRoots == null) {
            this.domainRoots = new ArrayList<SqmRoot>();
        }
        this.domainRoots.add(root);
    }

    public void visitRoots(Consumer<SqmRoot> consumer) {
        if (this.domainRoots != null) {
            this.domainRoots.forEach(consumer);
        }
    }

    public int getNumberOfRoots() {
        if (this.domainRoots == null) {
            return 0;
        }
        return this.domainRoots.size();
    }
}

