/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.SortOrder;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.QueryLiteralRendering;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.JdbcLiteralFormatter;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.EntityTypeLiteral;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.JdbcLiteral;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SelfRenderingExpression;
import org.hibernate.sql.ast.tree.expression.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.UnaryOperation;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;
import org.hibernate.sql.ast.tree.predicate.BetweenPredicate;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.GroupedPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NegatedPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.exec.internal.JdbcParametersImpl;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.results.internal.EmptySqlSelection;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptorIndicators;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractSqlAstWalker
implements SqlAstWalker,
SqlTypeDescriptorIndicators {
    private final SessionFactoryImplementor sessionFactory;
    private final SqlAppender sqlAppender = this::appendSql;
    private final StringBuilder sqlBuffer = new StringBuilder();
    private final List<JdbcParameterBinder> parameterBinders = new ArrayList<JdbcParameterBinder>();
    private final JdbcParametersImpl jdbcParameters = new JdbcParametersImpl();
    private final Stack<Clause> clauseStack = new StandardStack<Clause>();
    private final Dialect dialect;

    protected AbstractSqlAstWalker(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.dialect = sessionFactory.getJdbcServices().getDialect();
    }

    public String getSql() {
        return this.sqlBuffer.toString();
    }

    public List<JdbcParameterBinder> getParameterBinders() {
        return this.parameterBinders;
    }

    protected SqlAppender getSqlAppender() {
        return this.sqlAppender;
    }

    protected void appendSql(String fragment) {
        this.sqlBuffer.append(fragment);
    }

    protected void appendSql(char fragment) {
        this.sqlBuffer.append(fragment);
    }

    protected JdbcServices getJdbcServices() {
        return this.getSessionFactory().getJdbcServices();
    }

    protected boolean isCurrentlyInPredicate() {
        return this.clauseStack.getCurrent() == Clause.WHERE || this.clauseStack.getCurrent() == Clause.HAVING;
    }

    protected Stack<Clause> getClauseStack() {
        return this.clauseStack;
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        List<SortSpecification> sortSpecifications;
        if (!querySpec.isRoot()) {
            this.appendSql(" (");
        }
        this.visitSelectClause(querySpec.getSelectClause());
        this.visitFromClause(querySpec.getFromClause());
        if (querySpec.getWhereClauseRestrictions() != null && !querySpec.getWhereClauseRestrictions().isEmpty()) {
            this.appendSql(" where ");
            this.clauseStack.push(Clause.WHERE);
            try {
                querySpec.getWhereClauseRestrictions().accept(this);
            }
            finally {
                this.clauseStack.pop();
            }
        }
        if ((sortSpecifications = querySpec.getSortSpecifications()) != null && !sortSpecifications.isEmpty()) {
            this.appendSql(" order by ");
            String separator = "";
            for (SortSpecification sortSpecification : sortSpecifications) {
                this.appendSql(separator);
                this.visitSortSpecification(sortSpecification);
                separator = ", ";
            }
        }
        this.visitLimitOffsetClause(querySpec);
        if (!querySpec.isRoot()) {
            this.appendSql(")");
        }
    }

    @Override
    public void visitSortSpecification(SortSpecification sortSpecification) {
        SortOrder sortOrder;
        sortSpecification.getSortExpression().accept(this);
        String collation = sortSpecification.getCollation();
        if (collation != null) {
            this.appendSql(" collate ");
            this.appendSql(collation);
        }
        if ((sortOrder = sortSpecification.getSortOrder()) == SortOrder.ASCENDING) {
            this.appendSql(" asc");
        } else if (sortOrder == SortOrder.DESCENDING) {
            this.appendSql(" desc");
        }
    }

    @Override
    public void visitLimitOffsetClause(QuerySpec querySpec) {
        if (querySpec.getOffsetClauseExpression() != null) {
            this.renderOffset(querySpec);
        }
        if (querySpec.getLimitClauseExpression() != null) {
            this.renderLimit(querySpec);
        }
    }

    protected void renderOffset(QuerySpec querySpec) {
        this.appendSql(" offset ");
        querySpec.getOffsetClauseExpression().accept(this);
        this.appendSql(" rows");
    }

    protected void renderLimit(QuerySpec querySpec) {
        this.appendSql(" fetch first ");
        querySpec.getLimitClauseExpression().accept(this);
        this.appendSql(" rows only");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitSelectClause(SelectClause selectClause) {
        this.clauseStack.push(Clause.SELECT);
        try {
            this.appendSql("select ");
            if (selectClause.isDistinct()) {
                this.appendSql("distinct ");
            }
            String separator = "";
            for (SqlSelection sqlSelection : selectClause.getSqlSelections()) {
                if (sqlSelection instanceof EmptySqlSelection) continue;
                this.appendSql(separator);
                sqlSelection.accept(this);
                separator = ", ";
            }
        }
        finally {
            this.clauseStack.pop();
        }
    }

    @Override
    public void visitSqlSelection(SqlSelection sqlSelection) {
    }

    @Override
    public void visitFromClause(FromClause fromClause) {
        this.appendSql(" from ");
        String separator = "";
        for (TableGroup root : fromClause.getRoots()) {
            this.appendSql(separator);
            this.renderTableGroup(root);
            separator = ", ";
        }
    }

    protected void renderTableGroup(TableGroup tableGroup) {
        this.renderTableReference(tableGroup.getPrimaryTableReference());
        this.renderTableReferenceJoins(tableGroup);
        this.processTableGroupJoins(tableGroup);
    }

    protected void renderTableGroup(TableGroup tableGroup, Predicate predicate) {
        this.renderTableReference(tableGroup.getPrimaryTableReference());
        this.appendSql(" on ");
        predicate.accept(this);
        this.renderTableReferenceJoins(tableGroup);
        this.processTableGroupJoins(tableGroup);
    }

    protected void renderTableReference(TableReference tableReference) {
        this.sqlAppender.appendSql(tableReference.getTableExpression());
        String identificationVariable = tableReference.getIdentificationVariable();
        if (identificationVariable != null) {
            this.sqlAppender.appendSql(" as ");
            this.sqlAppender.appendSql(identificationVariable);
        }
    }

    protected void renderTableReferenceJoins(TableGroup tableGroup) {
        List<TableReferenceJoin> joins = tableGroup.getTableReferenceJoins();
        if (joins == null || joins.isEmpty()) {
            return;
        }
        for (TableReferenceJoin tableJoin : joins) {
            this.sqlAppender.appendSql(" ");
            this.sqlAppender.appendSql(tableJoin.getJoinType().getText());
            this.sqlAppender.appendSql(" join ");
            this.renderTableReference(tableJoin.getJoinedTableReference());
            if (tableJoin.getJoinPredicate() == null || tableJoin.getJoinPredicate().isEmpty()) continue;
            this.sqlAppender.appendSql(" on ");
            tableJoin.getJoinPredicate().accept(this);
        }
    }

    protected void processTableGroupJoins(TableGroup source) {
        source.visitTableGroupJoins(this::processTableGroupJoin);
    }

    protected void processTableGroupJoin(TableGroupJoin tableGroupJoin) {
        TableGroup joinedGroup = tableGroupJoin.getJoinedGroup();
        if (!(joinedGroup instanceof VirtualTableGroup)) {
            this.appendSql(" ");
            this.appendSql(tableGroupJoin.getJoinType().getText());
            this.appendSql(" join ");
            if (tableGroupJoin.getPredicate() != null && !tableGroupJoin.getPredicate().isEmpty()) {
                this.renderTableGroup(joinedGroup, tableGroupJoin.getPredicate());
            } else {
                this.renderTableGroup(joinedGroup);
            }
        }
    }

    @Override
    public void visitTableGroup(TableGroup tableGroup) {
    }

    @Override
    public void visitTableGroupJoin(TableGroupJoin tableGroupJoin) {
    }

    @Override
    public void visitTableReference(TableReference tableReference) {
    }

    @Override
    public void visitTableReferenceJoin(TableReferenceJoin tableReferenceJoin) {
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        if (columnReference.getQualifier() != null) {
            this.appendSql(columnReference.getQualifier());
            this.appendSql(".");
        }
        this.appendSql(columnReference.getColumnExpression());
    }

    @Override
    public void visitParameter(JdbcParameter jdbcParameter) {
        this.appendSql("?");
        this.parameterBinders.add(jdbcParameter.getParameterBinder());
        this.jdbcParameters.addParameter(jdbcParameter);
    }

    @Override
    public void visitTuple(SqlTuple tuple) {
        boolean isCurrentWhereClause;
        String separator = "";
        boolean bl = isCurrentWhereClause = this.clauseStack.getCurrent() == Clause.WHERE;
        if (isCurrentWhereClause) {
            this.appendSql("(");
        }
        for (Expression expression : tuple.getExpressions()) {
            this.appendSql(separator);
            expression.accept(this);
            separator = ", ";
        }
        if (isCurrentWhereClause) {
            this.appendSql(")");
        }
    }

    @Override
    public void visitSqlSelectionExpression(SqlSelectionExpression expression) {
        boolean useSelectionPosition = this.dialect.replaceResultVariableInOrderByClauseWithPosition();
        if (useSelectionPosition) {
            this.appendSql(Integer.toString(expression.getSelection().getJdbcResultSetIndex()));
        } else {
            expression.getExpression().accept(this);
        }
    }

    @Override
    public void visitEntityTypeLiteral(EntityTypeLiteral expression) {
        throw new NotYetImplementedFor6Exception("Mapping model subclass support not yet implemented");
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        arithmeticExpression.getLeftHandOperand().accept(this);
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        arithmeticExpression.getRightHandOperand().accept(this);
    }

    @Override
    public void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression) {
        this.dialect.getCaseExpressionWalker().visitCaseSearchedExpression(caseSearchedExpression, this.sqlBuffer, this);
    }

    @Override
    public void visitCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression) {
        this.appendSql(" case");
        caseSimpleExpression.getFixture().accept(this);
        for (CaseSimpleExpression.WhenFragment whenFragment : caseSimpleExpression.getWhenFragments()) {
            this.appendSql(" when ");
            whenFragment.getCheckValue().accept(this);
            this.appendSql(" then ");
            whenFragment.getResult().accept(this);
        }
        this.appendSql(" else ");
        caseSimpleExpression.getOtherwise().accept(this);
        this.appendSql(" end");
    }

    protected void visitJdbcParameterBinder(JdbcParameterBinder jdbcParameterBinder) {
        this.parameterBinders.add(jdbcParameterBinder);
        this.appendSql("?");
    }

    @Override
    public void visitJdbcLiteral(JdbcLiteral jdbcLiteral) {
        this.renderAsLiteral(jdbcLiteral);
    }

    @Override
    public void visitQueryLiteral(QueryLiteral queryLiteral) {
        QueryLiteralRendering queryLiteralRendering = this.getSessionFactory().getSessionFactoryOptions().getQueryLiteralRenderingMode();
        switch (queryLiteralRendering) {
            case AS_LITERAL: {
                this.renderAsLiteral(queryLiteral);
                break;
            }
            case AS_PARAM: {
                this.visitJdbcParameterBinder(queryLiteral);
                break;
            }
            case AUTO: 
            case AS_PARAM_OUTSIDE_SELECT: {
                if (this.clauseStack.getCurrent() == Clause.SELECT) {
                    this.renderAsLiteral(queryLiteral);
                    break;
                }
                this.visitJdbcParameterBinder(queryLiteral);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized QueryLiteralRendering : " + (Object)((Object)queryLiteralRendering));
            }
        }
    }

    private void renderAsLiteral(Literal literal) {
        if (literal.getLiteralValue() == null) {
            this.appendSql("null");
        } else {
            assert (literal.getExpressionType().getJdbcTypeCount(this.getTypeConfiguration()) == 1);
            JdbcMapping jdbcMapping = literal.getJdbcMapping();
            JdbcLiteralFormatter<Object> literalFormatter = jdbcMapping.getSqlTypeDescriptor().getJdbcLiteralFormatter(jdbcMapping.getJavaTypeDescriptor());
            this.appendSql(literalFormatter.toJdbcLiteral(literal.getLiteralValue(), this.dialect, null));
        }
    }

    @Override
    public void visitUnaryOperationExpression(UnaryOperation unaryOperationExpression) {
        if (unaryOperationExpression.getOperator() == UnaryArithmeticOperator.UNARY_PLUS) {
            this.appendSql(UnaryArithmeticOperator.UNARY_PLUS.getOperatorChar());
        } else {
            this.appendSql(UnaryArithmeticOperator.UNARY_MINUS.getOperatorChar());
        }
        unaryOperationExpression.getOperand().accept(this);
    }

    @Override
    public void visitSelfRenderingPredicate(SelfRenderingPredicate selfRenderingPredicate) {
        selfRenderingPredicate.getSelfRenderingExpression().accept(this);
    }

    @Override
    public void visitSelfRenderingExpression(SelfRenderingExpression expression) {
        expression.renderToSql(this.sqlAppender, this, this.getSessionFactory());
    }

    @Override
    public void visitBetweenPredicate(BetweenPredicate betweenPredicate) {
        betweenPredicate.getExpression().accept(this);
        if (betweenPredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" between ");
        betweenPredicate.getLowerBound().accept(this);
        this.appendSql(" and ");
        betweenPredicate.getUpperBound().accept(this);
    }

    @Override
    public void visitFilterPredicate(FilterPredicate filterPredicate) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public void visitGroupedPredicate(GroupedPredicate groupedPredicate) {
        if (groupedPredicate.isEmpty()) {
            return;
        }
        this.appendSql("(");
        groupedPredicate.getSubPredicate().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitInListPredicate(InListPredicate inListPredicate) {
        inListPredicate.getTestExpression().accept(this);
        if (inListPredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" in (");
        if (inListPredicate.getListExpressions().isEmpty()) {
            this.appendSql("null");
        } else {
            String separator = "";
            for (Expression expression : inListPredicate.getListExpressions()) {
                this.appendSql(separator);
                expression.accept(this);
                separator = ", ";
            }
        }
        this.appendSql(")");
    }

    @Override
    public void visitInSubQueryPredicate(InSubQueryPredicate inSubQueryPredicate) {
        inSubQueryPredicate.getTestExpression().accept(this);
        if (inSubQueryPredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" in ");
        this.visitQuerySpec(inSubQueryPredicate.getSubQuery());
    }

    @Override
    public void visitJunction(Junction junction) {
        if (junction.isEmpty()) {
            return;
        }
        String separator = "";
        for (Predicate predicate : junction.getPredicates()) {
            this.appendSql(separator);
            predicate.accept(this);
            if (separator != "") continue;
            separator = junction.getNature() == Junction.Nature.CONJUNCTION ? " and " : " or ";
        }
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        likePredicate.getMatchExpression().accept(this);
        if (likePredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" like ");
        likePredicate.getPattern().accept(this);
        if (likePredicate.getEscapeCharacter() != null) {
            this.appendSql(" escape ");
            likePredicate.getEscapeCharacter().accept(this);
        }
    }

    @Override
    public void visitNegatedPredicate(NegatedPredicate negatedPredicate) {
        if (negatedPredicate.isEmpty()) {
            return;
        }
        this.appendSql("not (");
        negatedPredicate.getPredicate().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitNullnessPredicate(NullnessPredicate nullnessPredicate) {
        nullnessPredicate.getExpression().accept(this);
        if (nullnessPredicate.isNegated()) {
            this.appendSql(" is not null");
        } else {
            this.appendSql(" is null");
        }
    }

    @Override
    public void visitRelationalPredicate(ComparisonPredicate comparisonPredicate) {
        comparisonPredicate.getLeftHandExpression().accept(this);
        this.appendSql(" ");
        this.appendSql(comparisonPredicate.getOperator().sqlText());
        this.appendSql(" ");
        comparisonPredicate.getRightHandExpression().accept(this);
    }

    @Override
    public boolean isNationalized() {
        return false;
    }

    @Override
    public boolean isLob() {
        return false;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.getSessionFactory().getTypeConfiguration();
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }
}

