/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.List;
import org.hibernate.sql.ast.spi.CaseExpressionWalker;
import org.hibernate.sql.ast.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class DecodeCaseExpressionWalker
implements CaseExpressionWalker {
    public static final DecodeCaseExpressionWalker INSTANCE = new DecodeCaseExpressionWalker();

    @Override
    public void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, StringBuilder sqlBuffer, SqlAstWalker sqlAstWalker) {
        sqlBuffer.append("decode( ");
        List<CaseSearchedExpression.WhenFragment> whenFragments = caseSearchedExpression.getWhenFragments();
        int caseNumber = whenFragments.size();
        CaseSearchedExpression.WhenFragment firstWhenFragment = null;
        for (int i = 0; i < caseNumber; ++i) {
            CaseSearchedExpression.WhenFragment whenFragment = whenFragments.get(i);
            Predicate predicate = whenFragment.getPredicate();
            if (i != 0) {
                sqlBuffer.append(", ");
                this.getLeftHandExpression(predicate).accept(sqlAstWalker);
                sqlBuffer.append(", ");
                whenFragment.getResult().accept(sqlAstWalker);
                continue;
            }
            this.getLeftHandExpression(predicate).accept(sqlAstWalker);
            firstWhenFragment = whenFragment;
        }
        sqlBuffer.append(", ");
        firstWhenFragment.getResult().accept(sqlAstWalker);
        Expression otherwise = caseSearchedExpression.getOtherwise();
        if (otherwise != null) {
            sqlBuffer.append(", ");
            otherwise.accept(sqlAstWalker);
        }
        sqlBuffer.append(')');
    }

    protected Expression getLeftHandExpression(Predicate predicate) {
        if (predicate instanceof NullnessPredicate) {
            return ((NullnessPredicate)predicate).getExpression();
        }
        assert (predicate instanceof ComparisonPredicate);
        return ((ComparisonPredicate)predicate).getLeftHandExpression();
    }
}

