/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.SqlTreeCreationLogger;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.tree.from.TableGroup;

public class SimpleFromClauseAccessImpl
implements FromClauseAccess {
    protected final Map<NavigablePath, TableGroup> tableGroupMap = new HashMap<NavigablePath, TableGroup>();

    @Override
    public TableGroup findTableGroup(NavigablePath navigablePath) {
        return this.tableGroupMap.get(navigablePath);
    }

    @Override
    public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
        TableGroup previous = this.tableGroupMap.put(navigablePath, tableGroup);
        if (previous != null) {
            SqlTreeCreationLogger.LOGGER.debugf("Registration of TableGroup [%s] for NavigablePath [%s] overrode previous registration : %s", (Object)tableGroup, (Object)navigablePath, (Object)previous);
        }
        if (this.containsAlias(navigablePath)) {
            this.tableGroupMap.put(this.getPathWithoutAlias(navigablePath), tableGroup);
        }
    }

    protected boolean containsAlias(NavigablePath navigablePath) {
        return navigablePath.getLocalName().endsWith(")");
    }

    protected NavigablePath getPathWithoutAlias(NavigablePath navigablePath) {
        String fullPath = navigablePath.getFullPath();
        String navigableName = fullPath.substring(fullPath.lastIndexOf(46) + 1, fullPath.lastIndexOf(40));
        return new NavigablePath(navigablePath.getParent(), navigableName);
    }
}

