/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.sql.ast.SqlTreeCreationLogger;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;

public class SqlAliasBaseManager
implements SqlAliasBaseGenerator {
    private Map<String, Integer> acronymCountMap = new HashMap<String, Integer>();

    @Override
    public SqlAliasBase createSqlAliasBase(String stem) {
        Integer acronymCount = this.acronymCountMap.get(stem);
        if (acronymCount == null) {
            acronymCount = 0;
        }
        Integer n = acronymCount;
        Integer n2 = acronymCount = Integer.valueOf(acronymCount + 1);
        this.acronymCountMap.put(stem, acronymCount);
        return new SqlAliasBaseImpl(stem + acronymCount);
    }

    private static class SqlAliasBaseImpl
    implements SqlAliasBase {
        private final String stem;
        private int aliasCount;

        SqlAliasBaseImpl(String stem) {
            this.stem = stem;
        }

        @Override
        public String getAliasStem() {
            return this.stem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String generateNewAlias() {
            SqlAliasBaseImpl sqlAliasBaseImpl = this;
            synchronized (sqlAliasBaseImpl) {
                String alias = this.stem + "_" + this.aliasCount++;
                if (SqlTreeCreationLogger.DEBUG_ENABLED) {
                    SqlTreeCreationLogger.LOGGER.debugf("Created new SQL alias : %s", (Object)alias);
                }
                return alias;
            }
        }
    }
}

