/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.spi;

import java.util.List;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.SqlAstInsertSelectTranslator;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.cte.CteColumn;
import org.hibernate.sql.ast.tree.cte.CteStatement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.exec.spi.JdbcInsert;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;

public class StandardSqlAstInsertSelectTranslator
extends AbstractSqlAstTranslator
implements SqlAstInsertSelectTranslator {
    public StandardSqlAstInsertSelectTranslator(SessionFactoryImplementor sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public JdbcInsert translate(InsertSelectStatement sqlAst) {
        this.appendSql("insert into ");
        this.appendSql(sqlAst.getTargetTable().getTableExpression());
        this.appendSql(" (");
        boolean firstPass = true;
        List<ColumnReference> targetColumnReferences = sqlAst.getTargetColumnReferences();
        if (targetColumnReferences == null) {
            this.renderImplicitTargetColumnSpec();
        } else {
            for (int i = 0; i < targetColumnReferences.size(); ++i) {
                if (firstPass) {
                    firstPass = false;
                } else {
                    this.appendSql(", ");
                }
                ColumnReference columnReference = targetColumnReferences.get(i);
                this.appendSql(columnReference.getColumnExpression());
            }
        }
        this.appendSql(") ");
        this.visitQuerySpec(sqlAst.getSourceSelectStatement());
        return new JdbcInsert(){

            @Override
            public String getSql() {
                return StandardSqlAstInsertSelectTranslator.this.getSql();
            }

            @Override
            public List<JdbcParameterBinder> getParameterBinders() {
                return StandardSqlAstInsertSelectTranslator.this.getParameterBinders();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return StandardSqlAstInsertSelectTranslator.this.getAffectedTableNames();
            }
        };
    }

    private void renderImplicitTargetColumnSpec() {
    }

    @Override
    public JdbcInsert translate(CteStatement sqlAst) {
        assert (sqlAst.getCteConsumer() instanceof DeleteStatement);
        this.appendSql("with ");
        this.appendSql(sqlAst.getCteLabel());
        this.appendSql(" (");
        String separator = "";
        for (int i = 0; i < sqlAst.getCteTable().getCteColumns().size(); ++i) {
            CteColumn cteColumn = sqlAst.getCteTable().getCteColumns().get(i);
            this.appendSql(separator);
            this.appendSql(cteColumn.getColumnExpression());
            separator = ", ";
        }
        this.appendSql(") as (");
        this.visitQuerySpec(sqlAst.getCteDefinition());
        this.appendSql(") ");
        this.translate((InsertSelectStatement)sqlAst.getCteConsumer());
        return new JdbcInsert(){

            @Override
            public String getSql() {
                return StandardSqlAstInsertSelectTranslator.this.getSql();
            }

            @Override
            public List<JdbcParameterBinder> getParameterBinders() {
                return StandardSqlAstInsertSelectTranslator.this.getParameterBinders();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return StandardSqlAstInsertSelectTranslator.this.getAffectedTableNames();
            }
        };
    }
}

