/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.spi.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.domain.basic.BasicResult;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class QueryLiteral<T>
implements Literal,
DomainResultProducer<T> {
    private final Object value;
    private final BasicValuedMapping type;

    public QueryLiteral(Object value, BasicValuedMapping type) {
        this.value = value;
        this.type = type;
    }

    @Override
    public Object getLiteralValue() {
        return this.value;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.type.getJdbcMapping();
    }

    @Override
    public void accept(SqlAstWalker walker) {
        walker.visitQueryLiteral(this);
    }

    @Override
    public BasicValuedMapping getExpressionType() {
        return this.type;
    }

    @Override
    public DomainResult<T> createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlAstCreationState().getSqlExpressionResolver();
        SqlSelection sqlSelection = sqlExpressionResolver.resolveSqlSelection(this, this.type.getMappedTypeDescriptor().getMappedJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), resultVariable, this.type.getMappedTypeDescriptor().getMappedJavaTypeDescriptor());
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, JavaTypeDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, this, this.type.getJdbcMapping());
    }

    @Override
    public void visitJdbcTypes(Consumer<JdbcMapping> action, TypeConfiguration typeConfiguration) {
        action.accept(this.type.getJdbcMapping());
    }

    @Override
    public void bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
        ((BasicType)this.getExpressionType()).getJdbcValueBinder().bind(statement, this.getLiteralValue(), startPosition, (WrapperOptions)executionContext.getSession());
    }
}

