/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.LockMode;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;

public class CompositeTableGroup
implements VirtualTableGroup {
    private final NavigablePath navigablePath;
    private final EmbeddableValuedModelPart compositionMapping;
    private final TableGroup underlyingTableGroup;
    private Set<TableGroupJoin> tableGroupJoins;

    public CompositeTableGroup(NavigablePath navigablePath, EmbeddableValuedModelPart compositionMapping, TableGroup underlyingTableGroup) {
        this.navigablePath = navigablePath;
        this.compositionMapping = compositionMapping;
        this.underlyingTableGroup = underlyingTableGroup;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public String getGroupAlias() {
        return null;
    }

    @Override
    public ModelPartContainer getModelPart() {
        return this.compositionMapping;
    }

    @Override
    public LockMode getLockMode() {
        return this.underlyingTableGroup.getLockMode();
    }

    @Override
    public Set<TableGroupJoin> getTableGroupJoins() {
        return this.tableGroupJoins == null ? Collections.emptySet() : Collections.unmodifiableSet(this.tableGroupJoins);
    }

    @Override
    public boolean hasTableGroupJoins() {
        return this.tableGroupJoins != null && !this.tableGroupJoins.isEmpty();
    }

    @Override
    public void setTableGroupJoins(Set<TableGroupJoin> joins) {
        if (this.tableGroupJoins == null) {
            this.tableGroupJoins = new HashSet<TableGroupJoin>(joins);
        } else {
            this.tableGroupJoins.addAll(joins);
        }
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        if (this.tableGroupJoins == null) {
            this.tableGroupJoins = new HashSet<TableGroupJoin>();
        }
        this.tableGroupJoins.add(join);
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.tableGroupJoins != null) {
            this.tableGroupJoins.forEach(consumer);
        }
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        this.underlyingTableGroup.applyAffectedTableNames(nameCollector);
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.underlyingTableGroup.getPrimaryTableReference();
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return this.underlyingTableGroup.getTableReferenceJoins();
    }

    @Override
    public boolean isInnerJoinPossible() {
        return this.underlyingTableGroup.isInnerJoinPossible();
    }

    @Override
    public TableReference resolveTableReference(String tableExpression, Supplier<TableReference> creator) {
        return this.underlyingTableGroup.resolveTableReference(tableExpression, creator);
    }

    @Override
    public TableReference resolveTableReference(String tableExpression) {
        return this.underlyingTableGroup.resolveTableReference(tableExpression);
    }
}

