/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.from.AbstractTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public class StandardTableGroup
extends AbstractTableGroup {
    private final TableReference primaryTableReference;
    private final List<TableReferenceJoin> tableJoins;

    public StandardTableGroup(NavigablePath navigablePath, TableGroupProducer tableGroupProducer, LockMode lockMode, TableReference primaryTableReference, List<TableReferenceJoin> tableJoins, SqlAliasBase sqlAliasBase, SessionFactoryImplementor sessionFactory) {
        super(navigablePath, tableGroupProducer, lockMode, sqlAliasBase, sessionFactory);
        this.primaryTableReference = primaryTableReference;
        this.tableJoins = tableJoins;
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        nameCollector.accept(this.getPrimaryTableReference().getTableExpression());
        for (TableReferenceJoin tableReferenceJoin : this.tableJoins) {
            nameCollector.accept(tableReferenceJoin.getJoinedTableReference().getTableExpression());
        }
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.primaryTableReference;
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return this.tableJoins;
    }

    @Override
    public TableReference resolveTableReferenceInternal(String tableExpression) {
        TableReference tableReference = super.resolveTableReferenceInternal(tableExpression);
        if (tableReference != null) {
            return tableReference;
        }
        for (TableReferenceJoin tableJoin : this.tableJoins) {
            if (!tableJoin.getJoinedTableReference().getTableExpression().equals(tableExpression)) continue;
            return tableJoin.getJoinedTableReference();
        }
        for (TableGroupJoin tableGroupJoin : this.getTableGroupJoins()) {
            TableReference primaryTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference();
            if (!primaryTableReference.getTableExpression().equals(tableExpression)) continue;
            return primaryTableReference;
        }
        return null;
    }
}

