/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceCollector;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.TableReferenceJoinPredicateProducer;

public class TableGroupBuilder
implements TableReferenceCollector {
    private final NavigablePath path;
    private final TableGroupProducer producer;
    private final SessionFactoryImplementor sessionFactory;
    private final SqlAliasBase sqlAliasBase;
    private final LockMode lockMode;
    private BiFunction<TableReference, TableReference, TableReferenceJoin> primaryJoinProducer;
    private TableReference primaryTableReference;
    private TableReference secondaryTableLhs;
    private List<TableReferenceJoin> tableJoins;

    public static TableGroupBuilder builder(NavigablePath path, TableGroupProducer producer, LockMode lockMode, SqlAliasBase sqlAliasBase, SessionFactoryImplementor sessionFactory) {
        return new TableGroupBuilder(path, producer, lockMode, sqlAliasBase, sessionFactory);
    }

    public static TableGroupBuilder builder(NavigablePath path, TableGroupProducer producer, LockMode lockMode, SqlAliasBase sqlAliasBase, BiFunction<TableReference, TableReference, TableReferenceJoin> primaryJoinProducer, SessionFactoryImplementor sessionFactory) {
        return new TableGroupBuilder(path, producer, lockMode, sqlAliasBase, primaryJoinProducer, sessionFactory);
    }

    private TableGroupBuilder(NavigablePath path, TableGroupProducer producer, LockMode lockMode, SqlAliasBase sqlAliasBase, SessionFactoryImplementor sessionFactory) {
        this(path, producer, lockMode, sqlAliasBase, null, sessionFactory);
    }

    private TableGroupBuilder(NavigablePath path, TableGroupProducer producer, LockMode lockMode, SqlAliasBase sqlAliasBase, BiFunction<TableReference, TableReference, TableReferenceJoin> primaryJoinProducer, SessionFactoryImplementor sessionFactory) {
        this.path = path;
        this.producer = producer;
        this.lockMode = lockMode;
        this.sqlAliasBase = sqlAliasBase;
        this.primaryJoinProducer = primaryJoinProducer;
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void applyPrimaryJoinProducer(BiFunction<TableReference, TableReference, TableReferenceJoin> primaryJoinProducer) {
        this.primaryJoinProducer = primaryJoinProducer;
    }

    public TableGroup build() {
        if (this.primaryTableReference == null) {
            throw new IllegalStateException("Primary TableReference was not specified : " + this.path);
        }
        return new StandardTableGroup(this.path, this.producer, this.lockMode, this.primaryTableReference, this.tableJoins == null ? Collections.emptyList() : this.tableJoins, this.sqlAliasBase, this.sessionFactory);
    }

    @Override
    public void applyPrimaryReference(TableReference tableReference) {
        if (this.primaryTableReference != null) {
            assert (this.primaryJoinProducer != null);
            this.addTableReferenceJoin(this.primaryJoinProducer.apply(this.primaryTableReference, tableReference));
        } else {
            this.primaryTableReference = tableReference;
        }
        this.secondaryTableLhs = tableReference;
    }

    @Override
    public void applySecondaryTableReferences(TableReference tableReference, JoinType tableReferenceJoinType, TableReferenceJoinPredicateProducer predicateProducer) {
        if (this.primaryTableReference == null) {
            this.secondaryTableLhs = this.primaryTableReference = tableReference;
        } else {
            this.addTableReferenceJoin(new TableReferenceJoin(tableReferenceJoinType, tableReference, predicateProducer.producePredicate(this.secondaryTableLhs, tableReference, tableReferenceJoinType)));
        }
    }

    @Override
    public void addTableReferenceJoin(TableReferenceJoin join) {
        if (this.tableJoins == null) {
            this.tableJoins = new ArrayList<TableReferenceJoin>();
        }
        this.tableJoins.add(join);
    }
}

