/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.sql.internal.DomainResultProducer;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;

public class TableGroupJoin
implements SqlAstNode,
DomainResultProducer {
    private final NavigablePath navigablePath;
    private final JoinType joinType;
    private final TableGroup joinedGroup;
    private Predicate predicate;

    public TableGroupJoin(NavigablePath navigablePath, JoinType joinType, TableGroup joinedGroup, Predicate predicate) {
        this.navigablePath = navigablePath;
        this.joinType = joinType;
        this.joinedGroup = joinedGroup;
        this.predicate = predicate;
    }

    public TableGroupJoin(NavigablePath navigablePath, JoinType joinType, TableGroup joinedGroup) {
        this(navigablePath, joinType, joinedGroup, null);
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public TableGroup getJoinedGroup() {
        return this.joinedGroup;
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public void applyPredicate(Predicate predicate) {
        this.predicate = SqlAstTreeHelper.combinePredicates(this.predicate, predicate);
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitTableGroupJoin(this);
    }

    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return this.getJoinedGroup().createDomainResult(resultVariable, creationState);
    }
}

