/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class TableReferenceJoin
implements SqlAstNode {
    private final JoinType joinType;
    private final TableReference joinedTableBinding;
    private final Predicate predicate;

    public TableReferenceJoin(JoinType joinType, TableReference joinedTableBinding, Predicate predicate) {
        this.joinType = joinType == null ? JoinType.LEFT : joinType;
        this.joinedTableBinding = joinedTableBinding;
        this.predicate = predicate;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public TableReference getJoinedTableReference() {
        return this.joinedTableBinding;
    }

    public Predicate getJoinPredicate() {
        return this.predicate;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitTableReferenceJoin(this);
    }

    public String toString() {
        return this.getJoinType().getText() + " join " + this.getJoinedTableReference().toString();
    }
}

