/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.insert;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.sql.ast.tree.MutationStatement;
import org.hibernate.sql.ast.tree.cte.CteConsumer;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.jboss.logging.Logger;

public class InsertSelectStatement
implements MutationStatement,
CteConsumer {
    private static final Logger log = Logger.getLogger(InsertSelectStatement.class);
    private TableReference targetTable;
    private List<ColumnReference> targetColumnReferences;
    private QuerySpec sourceSelectStatement = new QuerySpec(true);

    public TableReference getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(TableReference targetTable) {
        log.tracef("Setting INSERT-SELECT target table [%s]", (Object)targetTable);
        if (this.targetTable != null) {
            log.debugf("INSERT-SELECT target table has been set multiple times", new Object[0]);
        }
        this.targetTable = targetTable;
    }

    public List<ColumnReference> getTargetColumnReferences() {
        return this.targetColumnReferences == null ? Collections.emptyList() : this.targetColumnReferences;
    }

    public void addTargetColumnReferences(ColumnReference ... references) {
        if (this.targetColumnReferences == null) {
            this.targetColumnReferences = new ArrayList<ColumnReference>();
        }
        Collections.addAll(this.targetColumnReferences, references);
    }

    public void addTargetColumnReferences(List<ColumnReference> references) {
        if (this.targetColumnReferences == null) {
            this.targetColumnReferences = new ArrayList<ColumnReference>();
        }
        this.targetColumnReferences.addAll(references);
    }

    public QuerySpec getSourceSelectStatement() {
        return this.sourceSelectStatement;
    }

    public void setSourceSelectStatement(QuerySpec sourceSelectStatement) {
        this.sourceSelectStatement = sourceSelectStatement;
    }
}

