/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.select;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.sql.ast.spi.SqlAstTreeHelper;
import org.hibernate.sql.ast.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.cte.CteConsumer;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.PredicateContainer;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SortSpecification;

public class QuerySpec
implements SqlAstNode,
PredicateContainer,
Expression,
CteConsumer {
    private final boolean isRoot;
    private final FromClause fromClause;
    private final SelectClause selectClause = new SelectClause();
    private Predicate whereClauseRestrictions;
    private List<SortSpecification> sortSpecifications;
    private Expression limitClauseExpression;
    private Expression offsetClauseExpression;

    public QuerySpec(boolean isRoot) {
        this.isRoot = isRoot;
        this.fromClause = new FromClause();
    }

    public QuerySpec(boolean isRoot, int expectedNumberOfRoots) {
        this.isRoot = isRoot;
        this.fromClause = new FromClause(expectedNumberOfRoots);
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    public Predicate getWhereClauseRestrictions() {
        return this.whereClauseRestrictions;
    }

    @Override
    public void applyPredicate(Predicate predicate) {
        this.whereClauseRestrictions = SqlAstTreeHelper.combinePredicates(this.whereClauseRestrictions, predicate);
    }

    public List<SortSpecification> getSortSpecifications() {
        return this.sortSpecifications;
    }

    void visitSortSpecifications(Consumer<SortSpecification> consumer) {
        if (this.sortSpecifications != null) {
            this.sortSpecifications.forEach(consumer);
        }
    }

    public void addSortSpecification(SortSpecification specification) {
        if (this.sortSpecifications == null) {
            this.sortSpecifications = new ArrayList<SortSpecification>();
        }
        this.sortSpecifications.add(specification);
    }

    public Expression getLimitClauseExpression() {
        return this.limitClauseExpression;
    }

    public void setLimitClauseExpression(Expression limitClauseExpression) {
        this.limitClauseExpression = limitClauseExpression;
    }

    public Expression getOffsetClauseExpression() {
        return this.offsetClauseExpression;
    }

    public void setOffsetClauseExpression(Expression offsetClauseExpression) {
        this.offsetClauseExpression = offsetClauseExpression;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitQuerySpec(this);
    }

    @Override
    public MappingModelExpressable getExpressionType() {
        return null;
    }
}

