/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.CacheMode;
import org.hibernate.ScrollMode;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.query.internal.ScrollableResultsIterator;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.sql.exec.internal.JdbcExecHelper;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.sql.results.internal.DeferredResultSetAccess;
import org.hibernate.sql.results.internal.Helper;
import org.hibernate.sql.results.internal.JdbcValuesCacheHit;
import org.hibernate.sql.results.internal.JdbcValuesResultSetImpl;
import org.hibernate.sql.results.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.ResultSetAccess;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.spi.JdbcValues;
import org.hibernate.sql.results.spi.JdbcValuesMapping;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ListResultsConsumer;
import org.hibernate.sql.results.spi.ResultsConsumer;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.RowTransformer;
import org.hibernate.sql.results.spi.ScrollableResultsConsumer;
import org.jboss.logging.Logger;

public class JdbcSelectExecutorStandardImpl
implements JdbcSelectExecutor {
    public static final JdbcSelectExecutorStandardImpl INSTANCE = new JdbcSelectExecutorStandardImpl();
    private static final Logger log = Logger.getLogger(JdbcSelectExecutorStandardImpl.class);

    @Override
    public <R> List<R> list(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer) {
        return (List)this.executeQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), ListResultsConsumer.instance());
    }

    @Override
    public <R> ScrollableResultsImplementor<R> scroll(JdbcSelect jdbcSelect, ScrollMode scrollMode, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer) {
        return (ScrollableResultsImplementor)this.executeQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareQueryStatement((String)sql, true, scrollMode), ScrollableResultsConsumer.instance());
    }

    @Override
    public <R> Stream<R> stream(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer) {
        ScrollableResultsImplementor<R> scrollableResults = this.scroll(jdbcSelect, ScrollMode.FORWARD_ONLY, jdbcParameterBindings, executionContext, rowTransformer);
        ScrollableResultsIterator iterator = new ScrollableResultsIterator(scrollableResults);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        Stream stream = StreamSupport.stream(spliterator, false);
        return (Stream)stream.onClose(scrollableResults::close);
    }

    private <T, R> T executeQuery(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Function<String, PreparedStatement> statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        JdbcValues jdbcValues = this.resolveJdbcValuesSource(jdbcSelect, executionContext, new DeferredResultSetAccess(jdbcSelect, jdbcParameterBindings, executionContext, statementCreator));
        JdbcValuesSourceProcessingOptions processingOptions = new JdbcValuesSourceProcessingOptions(){

            @Override
            public Object getEffectiveOptionalObject() {
                return null;
            }

            @Override
            public String getEffectiveOptionalEntityName() {
                return null;
            }

            @Override
            public Serializable getEffectiveOptionalId() {
                return null;
            }

            @Override
            public boolean shouldReturnProxies() {
                return true;
            }
        };
        JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState = new JdbcValuesSourceProcessingStateStandardImpl(executionContext, processingOptions);
        ArrayList afterLoadActions = new ArrayList();
        RowReader<R> rowReader = Helper.createRowReader(executionContext.getSession().getFactory(), afterLoadActions::add, rowTransformer, jdbcValues);
        RowProcessingStateStandardImpl rowProcessingState = new RowProcessingStateStandardImpl(jdbcValuesSourceProcessingState, executionContext.getQueryOptions(), rowReader, jdbcValues);
        T result = resultsConsumer.consume(jdbcValues, executionContext.getSession(), processingOptions, jdbcValuesSourceProcessingState, rowProcessingState, rowReader);
        for (AfterLoadAction afterLoadAction : afterLoadActions) {
            afterLoadAction.afterLoad(executionContext.getSession(), null, null);
        }
        return result;
    }

    private JdbcValues resolveJdbcValuesSource(JdbcSelect jdbcSelect, ExecutionContext executionContext, ResultSetAccess resultSetAccess) {
        List cachedResults;
        QueryKey queryResultsCacheKey;
        boolean queryCacheEnabled = executionContext.getSession().getFactory().getSessionFactoryOptions().isQueryCacheEnabled();
        CacheMode cacheMode = JdbcExecHelper.resolveCacheMode(executionContext);
        JdbcValuesMapping jdbcValuesMapping = jdbcSelect.getJdbcValuesMappingProducer().resolve(resultSetAccess, executionContext.getSession().getFactory());
        if (queryCacheEnabled && cacheMode.isGetEnabled()) {
            log.debugf("Reading Query result cache data per CacheMode#isGetEnabled [%s]", (Object)cacheMode.name());
            QueryResultsCache queryCache = executionContext.getSession().getFactory().getCache().getQueryResultsCache(executionContext.getQueryOptions().getResultCacheRegionName());
            queryResultsCacheKey = QueryKey.from(jdbcSelect.getSql(), executionContext.getQueryOptions().getLimit(), executionContext.getQueryParameterBindings(), executionContext.getSession());
            cachedResults = queryCache.get(queryResultsCacheKey, jdbcSelect.getAffectedTableNames(), executionContext.getSession());
        } else {
            log.debugf("Skipping reading Query result cache data: cache-enabled = %s, cache-mode = %s", (Object)queryCacheEnabled, (Object)cacheMode.name());
            cachedResults = null;
            queryResultsCacheKey = null;
        }
        if (cachedResults == null || cachedResults.isEmpty()) {
            return new JdbcValuesResultSetImpl(resultSetAccess, queryResultsCacheKey, executionContext.getQueryOptions(), jdbcValuesMapping, executionContext);
        }
        return new JdbcValuesCacheHit(cachedResults, jdbcValuesMapping);
    }

    private static enum ExecuteAction {
        EXECUTE_QUERY;

    }
}

