/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.spi;

import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.sql.results.spi.LoadingEntityEntry;

public class StandardEntityInstanceResolver {
    private StandardEntityInstanceResolver() {
    }

    public static Object resolveEntityInstance(EntityKey entityKey, boolean eager, SharedSessionContractImplementor session) {
        Object managedEntity = session.getPersistenceContext().getEntity(entityKey);
        if (managedEntity != null) {
            return managedEntity;
        }
        LoadingEntityEntry loadingEntry = session.getPersistenceContext().getLoadContexts().findLoadingEntityEntry(entityKey);
        if (loadingEntry != null) {
            return loadingEntry.getEntityInstance();
        }
        return session.internalLoad(entityKey.getEntityName(), entityKey.getIdentifier(), eager, false);
    }
}

