/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.exec.spi.Callback;
import org.hibernate.sql.results.SqlResultsLogger;
import org.hibernate.sql.results.internal.StandardRowReader;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.JdbcValues;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.RowTransformer;

public class Helper {
    public static <R> RowReader<R> createRowReader(SessionFactoryImplementor sessionFactory, Callback callback, RowTransformer<R> rowTransformer, JdbcValues jdbcValues) {
        ArrayList<Initializer> initializers = new ArrayList<Initializer>();
        List<DomainResultAssembler> assemblers = jdbcValues.getValuesMapping().resolveAssemblers(Helper.getInitializerConsumer(initializers), () -> sessionFactory);
        return new StandardRowReader<R>(assemblers, initializers, rowTransformer, callback);
    }

    private static Consumer<Initializer> getInitializerConsumer(List<Initializer> initializers) {
        if (SqlResultsLogger.INSTANCE.isDebugEnabled()) {
            return initializer -> {
                SqlResultsLogger.INSTANCE.debug("Adding initializer : " + initializer);
                initializers.add((Initializer)initializer);
            };
        }
        return initializer -> initializers.add((Initializer)initializer);
    }
}

