/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.List;
import org.hibernate.sql.results.internal.AbstractJdbcValues;
import org.hibernate.sql.results.internal.caching.QueryCachePutManagerDisabledImpl;
import org.hibernate.sql.results.spi.JdbcValuesMapping;
import org.hibernate.sql.results.spi.RowProcessingState;

public class JdbcValuesCacheHit
extends AbstractJdbcValues {
    private Object[][] cachedData;
    private final int numberOfRows;
    private JdbcValuesMapping resolvedMapping;
    private int position = -1;

    public JdbcValuesCacheHit(Object[][] cachedData, JdbcValuesMapping resolvedMapping) {
        super(QueryCachePutManagerDisabledImpl.INSTANCE);
        this.cachedData = cachedData;
        this.numberOfRows = cachedData.length;
        this.resolvedMapping = resolvedMapping;
    }

    public JdbcValuesCacheHit(List<Object[]> cachedResults, JdbcValuesMapping resolvedMapping) {
        this((Object[][])cachedResults.toArray(), resolvedMapping);
    }

    @Override
    protected boolean processNext(RowProcessingState rowProcessingState) {
        if (this.isExhausted()) {
            return false;
        }
        ++this.position;
        return true;
    }

    private boolean isExhausted() {
        return this.position >= this.numberOfRows;
    }

    @Override
    public JdbcValuesMapping getValuesMapping() {
        return this.resolvedMapping;
    }

    @Override
    public Object[] getCurrentRowValuesArray() {
        if (this.isExhausted()) {
            return null;
        }
        return this.cachedData[this.position];
    }

    @Override
    protected void release() {
        this.cachedData = null;
    }
}

