/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.io.Serializable;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.spi.CollectionInitializer;
import org.hibernate.sql.results.spi.LoadingCollectionEntry;

public class LoadingCollectionEntryImpl
implements LoadingCollectionEntry {
    private final CollectionPersister collectionDescriptor;
    private final CollectionInitializer initializer;
    private final Object key;
    private final PersistentCollection collectionInstance;

    public LoadingCollectionEntryImpl(CollectionPersister collectionDescriptor, CollectionInitializer initializer, Object key, PersistentCollection collectionInstance) {
        this.collectionDescriptor = collectionDescriptor;
        this.initializer = initializer;
        this.key = key;
        this.collectionInstance = collectionInstance;
        collectionInstance.beforeInitialize(collectionDescriptor, -1);
        collectionInstance.beginRead();
    }

    @Override
    public CollectionPersister getCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    @Override
    public CollectionInitializer getInitializer() {
        return this.initializer;
    }

    @Override
    public Serializable getKey() {
        return (Serializable)this.key;
    }

    @Override
    public PersistentCollection getCollectionInstance() {
        return this.collectionInstance;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getCollectionDescriptor().getNavigableRole().getFullPath() + "#" + this.getKey() + ")";
    }

    @Override
    public void finishLoading(ExecutionContext executionContext) {
        this.collectionInstance.endRead();
        SharedSessionContractImplementor session = executionContext.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        CollectionPersister collectionDescriptor = this.getCollectionDescriptor();
        CollectionEntry collectionEntry = persistenceContext.getCollectionEntry(this.collectionInstance);
        if (collectionEntry == null) {
            collectionEntry = persistenceContext.addInitializedCollection(collectionDescriptor, this.getCollectionInstance(), this.getKey());
        } else {
            collectionEntry.postInitialize(this.collectionInstance);
        }
        if (collectionDescriptor.getCollectionType().hasHolder()) {
            persistenceContext.addCollectionHolder(this.collectionInstance);
        }
    }
}

