/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.Objects;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SqlExpressable;
import org.hibernate.sql.ast.spi.SqlAstWalker;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.descriptor.ValueExtractor;

public class SqlSelectionImpl
implements SqlSelection {
    private final int jdbcPosition;
    private final int valuesArrayPosition;
    private final Expression sqlExpression;
    private final JdbcMapping jdbcMapping;

    public SqlSelectionImpl(int jdbcPosition, int valuesArrayPosition, Expression sqlExpression, JdbcMapping jdbcMapping) {
        this.jdbcPosition = jdbcPosition;
        this.valuesArrayPosition = valuesArrayPosition;
        this.sqlExpression = sqlExpression;
        this.jdbcMapping = jdbcMapping;
    }

    public Expression getWrappedSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public ValueExtractor getJdbcValueExtractor() {
        return ((SqlExpressable)((Object)this.sqlExpression.getExpressionType())).getJdbcMapping().getJdbcValueExtractor();
    }

    @Override
    public int getJdbcResultSetIndex() {
        return this.jdbcPosition;
    }

    @Override
    public int getValuesArrayPosition() {
        return this.valuesArrayPosition;
    }

    @Override
    public void accept(SqlAstWalker interpreter) {
        this.sqlExpression.accept(interpreter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlSelectionImpl that = (SqlSelectionImpl)o;
        return this.jdbcPosition == that.jdbcPosition && this.valuesArrayPosition == that.valuesArrayPosition && Objects.equals(this.sqlExpression, that.sqlExpression);
    }

    public int hashCode() {
        return Objects.hash(this.jdbcPosition, this.valuesArrayPosition, this.sqlExpression);
    }
}

