/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain;

import java.util.Collections;
import java.util.List;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.Fetchable;
import org.hibernate.sql.results.spi.FetchableContainer;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public abstract class AbstractFetchParent
implements FetchParent {
    private final FetchableContainer fetchContainer;
    private final NavigablePath navigablePath;
    private List<Fetch> fetches;

    public AbstractFetchParent(FetchableContainer fetchContainer, NavigablePath navigablePath) {
        this.fetchContainer = fetchContainer;
        this.navigablePath = navigablePath;
        assert (fetchContainer instanceof ManagedMappingType);
    }

    protected void afterInitialize(DomainResultCreationState creationState) {
        this.fetches = creationState.visitFetches(this);
    }

    public FetchableContainer getFetchContainer() {
        return this.fetchContainer;
    }

    @Override
    public ManagedMappingType getReferencedMappingType() {
        return (ManagedMappingType)this.getFetchContainer();
    }

    @Override
    public JavaTypeDescriptor getResultJavaTypeDescriptor() {
        return this.getReferencedMappingType().getJavaTypeDescriptor();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public FetchableContainer getReferencedMappingContainer() {
        return this.fetchContainer;
    }

    @Override
    public List<Fetch> getFetches() {
        return this.fetches == null ? Collections.emptyList() : Collections.unmodifiableList(this.fetches);
    }

    @Override
    public Fetch findFetch(String fetchableName) {
        if (this.fetches != null) {
            for (Fetch fetch : this.fetches) {
                Fetchable fetchedMapping = fetch.getFetchedMapping();
                if (fetchedMapping == null || !fetchedMapping.getFetchableName().equals(fetchableName)) continue;
                return fetch;
            }
        }
        return null;
    }
}

