/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.FetchStrategy;
import org.hibernate.engine.FetchTiming;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.BiDirectionalFetch;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.Fetchable;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class BiDirectionalFetchImpl
implements BiDirectionalFetch,
Fetchable {
    private final NavigablePath navigablePath;
    private Fetchable fetchable;
    private NavigablePath referencedNavigablePath;
    private final FetchParent fetchParent;

    public BiDirectionalFetchImpl(NavigablePath navigablePath, FetchParent fetchParent, Fetchable fetchable, NavigablePath referencedNavigablePath) {
        this.fetchParent = fetchParent;
        this.navigablePath = navigablePath;
        this.fetchable = fetchable;
        this.referencedNavigablePath = referencedNavigablePath;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public NavigablePath getReferencedPath() {
        return this.referencedNavigablePath;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.fetchParent;
    }

    @Override
    public Fetchable getFetchedMapping() {
        return this.fetchable;
    }

    @Override
    public boolean isNullable() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    @Override
    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, Consumer<Initializer> collector, AssemblerCreationState creationState) {
        return new CircularFetchAssembler(this.getReferencedPath(), this.fetchable.getJavaTypeDescriptor());
    }

    @Override
    public String getFetchableName() {
        return this.fetchable.getFetchableName();
    }

    @Override
    public String getPartName() {
        return this.fetchable.getFetchableName();
    }

    @Override
    public JavaTypeDescriptor getJavaTypeDescriptor() {
        return this.fetchable.getJavaTypeDescriptor();
    }

    @Override
    public FetchStrategy getMappedFetchStrategy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, LockMode lockMode, String resultVariable, DomainResultCreationState creationState) {
        throw new UnsupportedOperationException();
    }

    private static class CircularFetchAssembler
    implements DomainResultAssembler {
        private final NavigablePath circularPath;
        private final JavaTypeDescriptor javaTypeDescriptor;

        public CircularFetchAssembler(NavigablePath circularPath, JavaTypeDescriptor javaTypeDescriptor) {
            this.circularPath = circularPath;
            this.javaTypeDescriptor = javaTypeDescriptor;
        }

        public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
            Initializer initializer = rowProcessingState.resolveInitializer(this.circularPath);
            if (initializer.getInitializedInstance() == null) {
                initializer.resolveKey(rowProcessingState);
                initializer.resolveInstance(rowProcessingState);
                initializer.initializeInstance(rowProcessingState);
            }
            return initializer.getInitializedInstance();
        }

        public JavaTypeDescriptor getAssembledJavaTypeDescriptor() {
            return this.javaTypeDescriptor;
        }
    }
}

