/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.basic;

import org.hibernate.Internal;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.results.SqlResultsLogger;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class BasicResultAssembler<J>
implements DomainResultAssembler<J> {
    private final int valuesArrayPosition;
    private final JavaTypeDescriptor<J> assembledJavaTypeDescriptor;
    private final BasicValueConverter<J, ?> valueConverter;

    public static <X> BasicResultAssembler<X> from(SqlSelection selection, JavaTypeDescriptor<X> javaTypeDescriptor) {
        return new BasicResultAssembler<X>(selection.getValuesArrayPosition(), javaTypeDescriptor);
    }

    public BasicResultAssembler(int valuesArrayPosition, JavaTypeDescriptor<J> assembledJavaTypeDescriptor) {
        this(valuesArrayPosition, assembledJavaTypeDescriptor, null);
    }

    public BasicResultAssembler(int valuesArrayPosition, JavaTypeDescriptor<J> assembledJavaTypeDescriptor, BasicValueConverter<J, ?> valueConverter) {
        this.valuesArrayPosition = valuesArrayPosition;
        this.assembledJavaTypeDescriptor = assembledJavaTypeDescriptor;
        this.valueConverter = valueConverter;
    }

    public Object extractRawValue(RowProcessingState rowProcessingState) {
        return rowProcessingState.getJdbcValue(this.valuesArrayPosition);
    }

    @Override
    public J assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
        Object jdbcValue = this.extractRawValue(rowProcessingState);
        SqlResultsLogger.INSTANCE.debugf("Extracted JDBC value [%d] - [%s]", this.valuesArrayPosition, jdbcValue);
        if (this.valueConverter != null) {
            assert (jdbcValue == null || this.valueConverter.getRelationalJavaDescriptor().getJavaType().isInstance(jdbcValue)) : "Expecting raw JDBC value of type [" + this.valueConverter.getRelationalJavaDescriptor().getJavaType().getName() + "] but found [" + jdbcValue + ']';
            return this.valueConverter.toDomainValue(jdbcValue);
        }
        return (J)jdbcValue;
    }

    @Override
    public JavaTypeDescriptor<J> getAssembledJavaTypeDescriptor() {
        return this.assembledJavaTypeDescriptor;
    }

    @Internal
    public BasicValueConverter<J, ?> getValueConverter() {
        return this.valueConverter;
    }
}

