/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.collection.CollectionLoadingLogger;
import org.hibernate.sql.results.spi.CollectionInitializer;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.RowProcessingState;

public abstract class AbstractCollectionInitializer
implements CollectionInitializer {
    private final NavigablePath collectionPath;
    private final PluralAttributeMapping collectionAttributeMapping;
    private final FetchParentAccess parentAccess;
    private final boolean selected;
    private final DomainResultAssembler keyContainerAssembler;
    private final DomainResultAssembler keyCollectionAssembler;
    private Object keyContainerValue;
    private Object keyCollectionValue;
    private CollectionKey collectionKey;

    protected AbstractCollectionInitializer(NavigablePath collectionPath, PluralAttributeMapping collectionAttributeMapping, FetchParentAccess parentAccess, boolean selected, DomainResultAssembler keyContainerAssembler, DomainResultAssembler keyCollectionAssembler) {
        this.collectionPath = collectionPath;
        this.collectionAttributeMapping = collectionAttributeMapping;
        this.parentAccess = parentAccess;
        this.selected = selected;
        this.keyContainerAssembler = keyContainerAssembler;
        this.keyCollectionAssembler = keyCollectionAssembler;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.collectionPath;
    }

    public PluralAttributeMapping getCollectionAttributeMapping() {
        return this.collectionAttributeMapping;
    }

    @Override
    public PluralAttributeMapping getInitializedPart() {
        return this.getCollectionAttributeMapping();
    }

    protected boolean isSelected() {
        return this.selected;
    }

    protected FetchParentAccess getParentAccess() {
        return this.parentAccess;
    }

    protected Object getKeyContainerValue() {
        return this.keyContainerValue;
    }

    protected Object getKeyCollectionValue() {
        return this.keyCollectionValue;
    }

    public CollectionKey resolveCollectionKey(RowProcessingState rowProcessingState) {
        this.resolveKey(rowProcessingState);
        return this.collectionKey;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.collectionKey != null) {
            return;
        }
        CollectionKey loadingKey = rowProcessingState.getCollectionKey();
        if (loadingKey != null) {
            this.collectionKey = loadingKey;
            return;
        }
        this.keyContainerValue = this.keyContainerAssembler.assemble(rowProcessingState, rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
        this.keyCollectionValue = this.keyCollectionAssembler == null || this.keyContainerAssembler == this.keyCollectionAssembler ? this.keyContainerValue : this.keyCollectionAssembler.assemble(rowProcessingState, rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
        Object keyContainerValue = this.getKeyContainerValue();
        if (keyContainerValue != null) {
            this.collectionKey = new CollectionKey(this.collectionAttributeMapping.getCollectionDescriptor(), keyContainerValue);
            if (CollectionLoadingLogger.DEBUG_ENABLED) {
                CollectionLoadingLogger.INSTANCE.debugf("(%s) Current row collection key : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), this.collectionKey.getKey()));
            }
        }
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.keyContainerValue = null;
        this.keyCollectionValue = null;
        this.collectionKey = null;
    }
}

