/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import org.hibernate.LockMode;
import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.internal.LoadingCollectionEntryImpl;
import org.hibernate.sql.results.internal.domain.collection.AbstractCollectionInitializer;
import org.hibernate.sql.results.internal.domain.collection.CollectionLoadingLogger;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.LoadingCollectionEntry;
import org.hibernate.sql.results.spi.RowProcessingState;

public abstract class AbstractImmediateCollectionInitializer
extends AbstractCollectionInitializer {
    private final LockMode lockMode;
    private PersistentCollection collectionInstance;
    private boolean responsible;
    private boolean collectionEmpty = true;

    public AbstractImmediateCollectionInitializer(NavigablePath collectionPath, PluralAttributeMapping collectionAttributeMapping, FetchParentAccess parentAccess, boolean selected, LockMode lockMode, DomainResultAssembler keyContainerAssembler, DomainResultAssembler keyCollectionAssembler) {
        super(collectionPath, collectionAttributeMapping, parentAccess, selected, keyContainerAssembler, keyCollectionAssembler);
        this.lockMode = lockMode;
    }

    @Override
    public PersistentCollection getCollectionInstance() {
        return this.collectionInstance;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        CollectionSemantics collectionSemantics;
        CollectionPersister collectionDescriptor;
        CollectionKey collectionKey;
        PersistenceContext persistenceContext;
        SharedSessionContractImplementor session;
        block22: {
            if (this.collectionInstance != null) {
                return;
            }
            session = rowProcessingState.getSession();
            persistenceContext = session.getPersistenceContext();
            collectionKey = this.resolveCollectionKey(rowProcessingState);
            if (CollectionLoadingLogger.TRACE_ENABLED) {
                CollectionLoadingLogger.INSTANCE.tracef("(%s) Beginning Initializer#resolveInstance for collection : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), collectionKey.getKey()));
            }
            LoadingCollectionEntry existingLoadingEntry = persistenceContext.getLoadContexts().findLoadingCollectionEntry(collectionKey);
            PluralAttributeMapping collectionAttributeMapping = this.getCollectionAttributeMapping();
            collectionDescriptor = collectionAttributeMapping.getCollectionDescriptor();
            collectionSemantics = collectionDescriptor.getCollectionSemantics();
            if (existingLoadingEntry != null) {
                this.collectionInstance = existingLoadingEntry.getCollectionInstance();
                if (CollectionLoadingLogger.DEBUG_ENABLED) {
                    CollectionLoadingLogger.INSTANCE.debugf("(%s) Found existing loading collection entry [%s]; using loading collection instance - %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), collectionKey.getKey()), (Object)LoggingHelper.toLoggableString(this.collectionInstance));
                }
                if (existingLoadingEntry.getInitializer() == this) {
                    this.responsible = true;
                    break block22;
                } else {
                    if (CollectionLoadingLogger.DEBUG_ENABLED) {
                        CollectionLoadingLogger.INSTANCE.debugf("(%s) Collection [%s] being loaded by another initializer [%s] - skipping processing", (Object)StringHelper.collapse(this.getClass().getName()), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), collectionKey.getKey()), (Object)existingLoadingEntry.getInitializer());
                    }
                    return;
                }
            }
            PersistentCollection existing = persistenceContext.getCollection(collectionKey);
            if (existing != null) {
                this.collectionInstance = existing;
                if (this.collectionInstance.wasInitialized()) {
                    if (CollectionLoadingLogger.DEBUG_ENABLED) {
                        CollectionLoadingLogger.INSTANCE.debugf("(%s) Found existing collection instance [%s] in Session; skipping processing - [%s]", (Object)StringHelper.collapse(this.getClass().getName()), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), collectionKey.getKey()), (Object)LoggingHelper.toLoggableString(this.collectionInstance));
                    }
                    return;
                }
                assert (this.isSelected());
                this.takeResponsibility(rowProcessingState, collectionKey);
            } else {
                PersistentCollection existingUnowned = persistenceContext.useUnownedCollection(collectionKey);
                if (existingUnowned != null) {
                    this.collectionInstance = existingUnowned;
                    if (this.collectionInstance.wasInitialized()) {
                        if (CollectionLoadingLogger.DEBUG_ENABLED) {
                            CollectionLoadingLogger.INSTANCE.debugf("(%s) Found existing unowned collection instance [%s] in Session; skipping processing - [%s]", (Object)StringHelper.collapse(this.getClass().getName()), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), collectionKey.getKey()), (Object)LoggingHelper.toLoggableString(this.collectionInstance));
                        }
                        return;
                    }
                    assert (this.isSelected());
                    this.takeResponsibility(rowProcessingState, collectionKey);
                }
            }
            if (!this.isSelected()) {
                this.collectionInstance = collectionSemantics.instantiateWrapper(collectionKey.getKey(), collectionDescriptor, session);
                persistenceContext.addNonLazyCollection(this.collectionInstance);
                return;
            }
        }
        if (this.collectionInstance == null && collectionKey != null) {
            this.collectionInstance = collectionSemantics.instantiateWrapper(collectionKey.getKey(), this.getInitializingCollectionDescriptor(), session);
            if (CollectionLoadingLogger.DEBUG_ENABLED) {
                CollectionLoadingLogger.INSTANCE.debugf("(%s) Created new collection wrapper [%s] : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), collectionKey.getKey()), (Object)LoggingHelper.toLoggableString(this.collectionInstance));
            }
            persistenceContext.addUninitializedCollection(collectionDescriptor, this.collectionInstance, collectionKey.getKey());
            this.takeResponsibility(rowProcessingState, collectionKey);
        }
        if (this.responsible) {
            if (CollectionLoadingLogger.DEBUG_ENABLED) {
                CollectionLoadingLogger.INSTANCE.debugf("(%s) Responsible for loading collection [%s] : %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), collectionKey.getKey()), (Object)LoggingHelper.toLoggableString(this.collectionInstance));
            }
            if (this.getParentAccess() != null) {
                this.getParentAccess().registerResolutionListener(owner -> this.collectionInstance.setOwner(owner));
            }
        }
    }

    protected void takeResponsibility(RowProcessingState rowProcessingState, CollectionKey collectionKey) {
        rowProcessingState.getJdbcValuesSourceProcessingState().registerLoadingCollection(collectionKey, new LoadingCollectionEntryImpl(this.getCollectionAttributeMapping().getCollectionDescriptor(), this, collectionKey.getKey(), this.collectionInstance));
        this.responsible = true;
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        if (!this.responsible) {
            return;
        }
        PersistenceContext persistenceContext = rowProcessingState.getSession().getPersistenceContext();
        CollectionKey collectionKey = this.resolveCollectionKey(rowProcessingState);
        Object keyCollectionValue = this.getKeyCollectionValue();
        if (keyCollectionValue != null) {
            if (CollectionLoadingLogger.DEBUG_ENABLED) {
                CollectionLoadingLogger.INSTANCE.debugf("(%s) Reading element from row for collection [%s] -> %s", (Object)StringHelper.collapse(this.getClass().getName()), (Object)LoggingHelper.toLoggableString(this.getNavigablePath(), collectionKey.getKey()), (Object)LoggingHelper.toLoggableString(this.collectionInstance));
            }
            this.readCollectionRow(rowProcessingState);
            this.collectionEmpty = false;
        }
    }

    protected abstract void readCollectionRow(RowProcessingState var1);

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        super.finishUpRow(rowProcessingState);
        this.collectionInstance = null;
        this.responsible = false;
        this.collectionEmpty = true;
    }

    @Override
    public void endLoading(ExecutionContext context) {
        CollectionKey collectionKey;
        if (this.getParentAccess() == null && this.collectionEmpty && (collectionKey = context.getCollectionKey()) != null) {
            PersistenceContext persistenceContext = context.getSession().getPersistenceContext();
            PersistentCollection collection = persistenceContext.getCollection(collectionKey);
            collection.beforeInitialize(this.getCollectionAttributeMapping().getCollectionDescriptor(), 0);
            collection.beginRead();
            collection.endRead();
            CollectionEntry entry = persistenceContext.getCollectionEntry(collection);
            if (entry != null) {
                entry.postInitialize(collection);
            }
        }
    }
}

