/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import org.hibernate.LockMode;
import org.hibernate.collection.internal.PersistentArrayHolder;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.collection.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.RowProcessingState;

public class ArrayInitializer
extends AbstractImmediateCollectionInitializer {
    private final DomainResultAssembler listIndexAssembler;
    private final DomainResultAssembler elementAssembler;
    private final int indexBase;

    public ArrayInitializer(NavigablePath navigablePath, PluralAttributeMapping arrayDescriptor, FetchParentAccess parentAccess, boolean selected, LockMode lockMode, DomainResultAssembler keyContainerAssembler, DomainResultAssembler keyCollectionAssembler, DomainResultAssembler listIndexAssembler, DomainResultAssembler elementAssembler) {
        super(navigablePath, arrayDescriptor, parentAccess, selected, lockMode, keyContainerAssembler, keyCollectionAssembler);
        this.listIndexAssembler = listIndexAssembler;
        this.elementAssembler = elementAssembler;
        this.indexBase = this.getCollectionAttributeMapping().getIndexMetadata().getListIndexBase();
    }

    @Override
    public PersistentArrayHolder getCollectionInstance() {
        return (PersistentArrayHolder)super.getCollectionInstance();
    }

    @Override
    protected void readCollectionRow(RowProcessingState rowProcessingState) {
        int index = (Integer)this.listIndexAssembler.assemble(rowProcessingState);
        if (this.indexBase != 0) {
            index -= this.indexBase;
        }
        this.getCollectionInstance().load(index, this.elementAssembler.assemble(rowProcessingState));
    }

    public String toString() {
        return "ArrayInitializer{" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

