/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import org.hibernate.LockMode;
import org.hibernate.collection.internal.PersistentBag;
import org.hibernate.collection.internal.PersistentIdentifierBag;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.collection.AbstractImmediateCollectionInitializer;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.RowProcessingState;

public class BagInitializer
extends AbstractImmediateCollectionInitializer {
    private final DomainResultAssembler elementAssembler;
    private final DomainResultAssembler collectionIdAssembler;

    public BagInitializer(PluralAttributeMapping bagDescriptor, FetchParentAccess parentAccess, NavigablePath navigablePath, boolean selected, LockMode lockMode, DomainResultAssembler keyContainerAssembler, DomainResultAssembler keyCollectionAssembler, DomainResultAssembler elementAssembler, DomainResultAssembler collectionIdAssembler) {
        super(navigablePath, bagDescriptor, parentAccess, selected, lockMode, keyContainerAssembler, keyCollectionAssembler);
        this.elementAssembler = elementAssembler;
        this.collectionIdAssembler = collectionIdAssembler;
    }

    @Override
    protected void readCollectionRow(RowProcessingState rowProcessingState) {
        if (this.collectionIdAssembler != null) {
            ((PersistentIdentifierBag)this.getCollectionInstance()).load(this.collectionIdAssembler.assemble(rowProcessingState), this.elementAssembler.assemble(rowProcessingState));
        } else {
            ((PersistentBag)this.getCollectionInstance()).load(this.elementAssembler.assemble(rowProcessingState));
        }
    }

    public String toString() {
        return "BagInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }
}

