/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal.domain.collection;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.collection.spi.CollectionInitializerProducer;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.internal.domain.collection.BagInitializer;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.CollectionInitializer;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.Initializer;

public class BagInitializerProducer
implements CollectionInitializerProducer {
    private final PluralAttributeMapping bagDescriptor;
    private final boolean selected;
    private final Fetch collectionIdFetch;
    private final Fetch elementFetch;

    public BagInitializerProducer(PluralAttributeMapping bagDescriptor, boolean selected, Fetch collectionIdFetch, Fetch elementFetch) {
        this.bagDescriptor = bagDescriptor;
        this.selected = selected;
        if (bagDescriptor.getIdentifierDescriptor() != null) {
            assert (collectionIdFetch != null);
            this.collectionIdFetch = collectionIdFetch;
        } else {
            assert (collectionIdFetch == null);
            this.collectionIdFetch = null;
        }
        this.elementFetch = elementFetch;
    }

    @Override
    public CollectionInitializer produceInitializer(NavigablePath navigablePath, PluralAttributeMapping attributeMapping, FetchParentAccess parentAccess, LockMode lockMode, DomainResultAssembler keyContainerAssembler, DomainResultAssembler keyCollectionAssembler, Consumer<Initializer> initializerConsumer, AssemblerCreationState creationState) {
        DomainResultAssembler elementAssembler = this.elementFetch.createAssembler(parentAccess, initializerConsumer, creationState);
        DomainResultAssembler collectionIdAssembler = this.bagDescriptor.getIdentifierDescriptor() == null ? null : this.collectionIdFetch.createAssembler(parentAccess, initializerConsumer, creationState);
        return new BagInitializer(this.bagDescriptor, parentAccess, navigablePath, this.selected, lockMode, keyContainerAssembler, keyCollectionAssembler, elementAssembler, collectionIdAssembler);
    }
}

